# Palmy.io

Live: https://www.palmy.io/

Palmy.io is a Nuxt 4 application with server routes and a typed backend powered by Prisma and PostgreSQL. It integrates Supabase for authentication and storage helpers, Stripe for payments, AWS S3 for media, OpenAI for AI features, and Google services where needed. The UI is built with Nuxt UI and Tailwind CSS.

## Tech Stack

- **Framework**: Nuxt 4, Vue 3, TypeScript
- **UI**: Nuxt UI, Nuxt Image, Tailwind CSS
- **Auth/Backend**: @nuxtjs/supabase, Nitro server routes
- **Database**: PostgreSQL, Prisma (@prisma/client, @prisma/adapter-pg)
- **Integrations**: Stripe, AWS S3, OpenAI, Google CSE, nuxt-gtag, nuxt-qrcode
- **Tooling**: ESLint, Prettier, pnpm

## Prerequisites

- Node.js 18+ (recommend LTS)
- pnpm (project uses `packageManager: pnpm`)
- PostgreSQL database (provide `DATABASE_URL`)
- Cloud credentials as applicable (Supabase, Stripe, AWS, Google CSE)

## Environment Variables

Create a `.env` file in the project root. Values below map to `runtimeConfig` in `nuxt.config.ts`.

Private (server only):

```
STRIPE_SECRET_KEY=
DOMAIN=
ENVIRONMENT=production
DATABASE_URL=
DIRECT_URL=
GOOGLE_API_KEY=
GOOGLE_CX_ID=
OPENAI_API_KEY=
SUPABASE_SRV_ROLE=
AWS_ACCESS_KEY_ID=
AWS_SECRET_ACCESS_KEY=
AWS_REGION=
S3_BUCKET_NAME=
JWT_SECRET=
APPLE_TEAM_ID=
APPLE_PASS_TYPE_ID=
APPLE_PASS_CERT_PATH=
APPLE_PASS_CERT_PASSWORD=
APPLE_WWDR_CERT_PATH=
```

Public (exposed to client):

```
BASE_URL=
GOOGLE_API_KEY=
GOOGLE_CX_ID=
SUPABASE_URL=
SUPABASE_KEY=
```

Notes:

- `DATABASE_URL` must point to a PostgreSQL instance; Prisma uses it via `@prisma/adapter-pg`.
- Apple Wallet passkit variables are required if generating passes.
- `SUPABASE_URL` and `SUPABASE_KEY` are the anon/public keys used by the client. Keep service role key server-side only.

## Setup

Install dependencies:

```bash
pnpm install
```

Generate Prisma client (and format schema if needed):

```bash
pnpm run PFormat
pnpm run PGenerate
```

If you have migrations, apply them to your database (example):

```bash
pnpm exec prisma migrate deploy
```

## Development

Start the dev server at http://localhost:3000

```bash
pnpm dev
```

Lint and typecheck:

```bash
pnpm lint
pnpm typecheck
```

## Build & Preview

Build for production:

```bash
pnpm build
```

Preview the production build locally:

```bash
pnpm preview
```

## Deployment Notes

- This is a server-rendered Nuxt 4 app with server routes; deploy to a Node-compatible environment and provide all environment variables.
- Ensure all private keys are set as server-side secrets. Only `public` keys are exposed to the client.
- Storage/CDN: set AWS S3 variables and bucket CORS as needed for uploads; `@nuxt/image` remote images are allowed via permissive pattern.
- Supabase auth redirects are configured in `nuxt.config.ts` under `supabase.redirectOptions`.

## Scripts (package.json)

- `dev`: nuxt dev
- `build`: nuxt build
- `preview`: nuxt preview
- `postinstall`: nuxt prepare
- `lint`: eslint .
- `typecheck`: nuxt typecheck
- `PGenerate`: npx prisma generate
- `PFormat`: npx prisma format
