// app/app.config.ts
export default defineAppConfig({
  ui: {
    colorMode: 'light',
    button: {
      base: 'rounded-2xl font-semibold cursor-pointer hover:-translate-y-[1px] hover:shadow-lg transition-all duration-300 text-default  justify-center',
      variants: {
        size: {
          xs: {base: 'px-3 py-2 text-xs rounded-pill'},
          sm: {base: 'px-4 py-2 text-sm rounded-xl'},
          md: {base: 'px-10 py-2.5 text-base rounded-2xl'},
          lg: {base: 'px-12 py-3 text-base rounded-2xl'},
          xl: {base: 'px-12 py-3.5 text-base rounded-2xl'},
        },
        color: {
          primary: '!text-dark disabled:!bg-gray-200',
          secondary: 'dark:text-gray-100 hover:border-primary hover:ring-primary',
        },
        variant: {
          outline: 'border-2',
          soft: '',
          ghost: '',
          link: 'text-primary hover:!shadow-none hover:underline p-0 dark:text-slate-100',
          subtle: '',
        },
      },
    },
    input: {
      slots: {
        root: 'w-full',
        base: 'disabled:bg-gray-200',
      },
      variants: {
        size: {
          xs: {base: 'px-2 py-1.5 text-xs rounded-lg'},
          sm: {base: 'px-2.5 py-2 text-sm rounded-xl'},
          md: {base: 'px-3 py-2.5 text-sm rounded-xl'},
          lg: {base: 'px-4 py-3 h-12 text-sm rounded-2xl'},
          xl: {base: 'px-5 py-4 text-base rounded-2xl'},
        },
      },
      defaultVariants: {
        size: 'lg',
      },
    },
    textarea: {
      slots: {
        root: 'w-full',
        base: 'disabled:bg-gray-200',
      },
      variants: {
        size: {
          xs: {base: 'px-2 py-1.5 text-xs rounded-lg'},
          sm: {base: 'px-2.5 py-2 text-sm rounded-xl'},
          md: {base: 'px-3 py-2.5 text-sm rounded-xl'},
          lg: {base: 'px-4 py-3 text-base rounded-2xl'},
          xl: {base: 'px-5 py-4 text-base rounded-2xl'},
        },
      },
      defaultVariants: {
        size: 'lg',
      },
    },
    select: {
      slots: {
        root: 'w-full',
        base: 'disabled:bg-gray-200 w-full',
      },
      variants: {
        size: {
          xs: {base: 'px-2.5 py-1.5 text-xs rounded-lg'},
          sm: {base: 'px-3 py-2 text-sm rounded-xl'},
          md: {base: 'px-4 py-2.5 text-sm rounded-xl'},
          lg: {base: 'px-6 py-3 h-12 text-sm rounded-2xl'},
          xl: {base: 'px-7 py-3.5 text-base rounded-2xl'},
        },
      },
      defaultVariants: {
        size: 'lg',
      },
    },
    selectMenu: {
      slots: {
        root: 'w-full',
        base: 'disabled:bg-gray-200 w-full',
      },
      variants: {
        size: {
          xs: {base: 'px-2.5 py-1.5 text-xs rounded-lg'},
          sm: {base: 'px-3 py-2 text-sm rounded-xl'},
          md: {base: 'px-4 py-2.5 text-sm rounded-xl'},
          lg: {base: 'px-6 py-3 text-sm h-12 rounded-2xl'},
          xl: {base: 'px-7 py-3.5 text-base rounded-2xl'},
        },
      },
      defaultVariants: {
        size: 'lg',
      },
    },
    modal: {
      slots: {
        overlay: 'inset-0 !bg-black/20 !backdrop-blur-sm ',
        content: '!min-w-xl !bg-white/90 dark:!bg-zinc-900 !rounded-2xl',
        title: 'text-xl font-bold text-gray-900 dark:text-white ',
        close: 'dark:!text-white',
      },
    },
    table: {
      slots: {
        root: 'shadow-sm rounded-2xl dark:border dark:border-gray-800',
        thead: '!bg-gray-50 dark:!bg-gray-900',
        th: 'px-6 py-4',
        td: 'px-6 py-4 !text-gray-700 dark:!text-gray-200',
      },
    },
    separator: {
      defaultVariants: {
        color: 'primary',
      },
    },
    card: {
      slots: {
        root: 'rounded-3xl !ring-gray-800 dark:!ring-gray-500 hover:shadow-[0_0_40px_rgba(0,0,0,0.10)]/20 transition-all duration-300 text-gray-900 dark:text-gray-300',
        body: '',
      },
      variants: {
        variant: {
          solid: {
            root: '!shadow-[0_18px_45px_rgba(0,0,0,0.08)] bg-white dark:bg-slate-900',
          },
          subtle: {
            root: ' bg-white dark:bg-slate-800 !ring-gray-200',
          },
        },
      },
      defaultVariants: {
        variant: 'outline',
      },
    },
    badge: {
      slots: {
        base: '!rounded-full capitalize',
      },
      variants: {
        variant: {
          subtle: 'font-semibold',
        },
      },
    },
    dashboardSidebar: {
      slots: {
        root: 'w-72',
        header: 'h-auto',
      },
    },
    formField: {
      slots: {
        label: 'font-semibold',
      },
    },
    toast: {
      slots: {
        wrapper: '',
        icon: 'text-2xl h-full',
      },
      variants: {
        color: {
          success: {
            root: 'ring-1 ring-green-500',
          },
          error: {
            root: 'ring-1 ring-red-500',
          },
        },
      },
    },
    navigationMenu: {
      slots: {
        link: 'text-sm font-medium gap-3 !px-5 !py-3 !text-gray-900 dark:!text-gray-100 active:!text-white',
        linkLeadingIcon: 'text-xl !text-gray-900 dark:!text-gray-100',
      },
      variants: {
        active: {
          true: {
            link: '!text-primary !font-semibold',
            linkLeadingIcon: '!text-primary',
          },
        },
      },
    },
    dashboardNavbar: {
      slots: {
        root: 'bg-secondary text-white !px-8 h-20 rounded-b-3xl',
        left: 'gap-3',
        title: 'text-white text-3xl',
      },
    },
    dashboardPanel: {
      slots: {
        root: 'bg-gray-50 dark:bg-gray-800',
      },
    },
    skeleton: {
      base: 'bg-slate-100 ring-1 ring-yellow-200 shadow-lg',
    },
    switch: {
      slots: {
        description: 'text-sm',
      },
    },
    fieldGroup: {
      base: 'w-full',
    },
  },
});
