export const projectStatus = ['queue', 'live', 'completed', 'archived'] as const;
export const userTypes = ['organizer', 'user', 'admin'] as const;
export const targetOptions = [1, 2, 3, 4, 5] as const;

export const projectCategories = ['fundraiser', 'drawing', 'contest', 'fanphoto', 'game'] as const;

export const prizeOptions = [
  {label: 'In Person', value: 'inPerson'},
  {label: 'Electronic (Palmy Pass)', value: 'electronic'},
];

export const contestOptions = [
  {label: 'Trivia', value: 'trivia'},
  {label: 'Survey/Polls', value: 'survey'},
  {label: 'Song Voting', value: 'song'},
];

export const gameOptions = [
  {label: 'Lucky Seat', value: 'seat'},
  // { label: 'Bingo', value: 'bingo' },
  {label: 'Target Tracker', value: 'target'},
  {label: 'Rate It', value: 'rateit'},
];

export const eventOptions = [
  {label: 'Trivia', value: 'trivia'},
  {label: 'Poll/Survey', value: 'poll'},
  {label: 'Game', value: 'game'},
];

export const drawingOptions = [{label: 'Drawing', value: 'drawing'}];

export const distributionOptions = [
  {label: 'Correct Answers/Winners', value: 'correct'},
  {label: 'All Participants', value: 'all'},
];

export const resultsOptions = [
  {label: 'In Person', value: 'inPerson'},
  {label: 'Online', value: 'online'},
];

export const allTypes = {
  electronic: 'Electronic (Palmy Pass)',
  inPerson: 'In Person',
  drawing: 'Drawing',
  traditional: 'Traditional',
  draw5050: '50/50 Drawing',
  game: 'Game',
  bingo: 'Bingo',
  target: 'Target Tracker',
  rateit: 'Rate It',
  trivia: 'Trivia',
  poll: 'Poll/Survey',
  survey: 'Survey/Polls',
  song: 'Song Voting',
  contest: 'Contest',
  fanphoto: 'Fan Photo',
  fundraiser: 'Fundraiser',
  correct: 'Correct Answers Only',
  all: 'All Participants',
  blackout: 'Blackout',
  seat: 'Lucky Seat',
  online: 'Online',
} as unknown as string;
