export const useLocation = async () => {
  if (!process.client) return { lat: 0, lng: 0, ip: null };

  // Fetch public IP using a simple API
  const ip = await fetch("https://api.ipify.org?format=json")
    .then((res) => res.json())
    .then((data) => data.ip)
    .catch(() => null);

  // If geolocation isn't supported
  if (!navigator.geolocation) {
    return { lat: 0, lng: 0, ip };
  }

  // Wrap geolocation in a Promise
  return new Promise((resolve) => {
    navigator.geolocation.getCurrentPosition(
      (position) => {
        resolve({
          lat: position.coords.latitude,
          lng: position.coords.longitude,
          ip,
        });
      },
      () => {
        resolve({ lat: 0, lng: 0, ip });
      }
    );
  });
};
