export async function useApi(
  url: string,
  options: Parameters<typeof useLazyFetch>[1] = {},
  key: string = ''
): Promise<{
  loading: boolean;
  error: boolean;
  result: object | null;
  total?: number | null;
  page?: number | null;
  totalPages?: number | null;
  message?: string | null;
}> {
  const { data, status } = useLazyFetch(url, { ...options, key });
  return { loading: status.value === 'pending', error: status.value === 'error', ...(data.value as unknown as { result: object | null; total?: number | null; page?: number | null; totalPages?: number | null; message?: string | null }) };
}
