export const useAuth = () => {
  const supabase = useSupabaseClient();
  const runtime = useRuntimeConfig();

  const isDevelopment = import.meta.env.DEV;
  const baseUrl = (() => {
    if (import.meta.env.SSR) {
      const url = useRequestURL();
      return `${url.protocol}//${url.host}`;
    }
    if (typeof window !== 'undefined') return window.location.origin;
    return runtime.public.BASE_URL || 'http://localhost:3000';
  })();

  const signInWithGoogle = async (nextPath: string = '/user/') => {
    try {
      console.log('Initiating Google OAuth...');
      console.log('Environment mode:', import.meta.env.MODE);
      console.log('Base URL:', baseUrl);
      // Short-lived intent cookie as a fallback for return path
      const intentValue = `rp:${nextPath}`;
      const isHttps = typeof window !== 'undefined' && window.location.protocol === 'https:';
      document.cookie = `oauth_intent=${encodeURIComponent(intentValue)}; Max-Age=600; Path=/; SameSite=Lax${isHttps ? '; Secure' : ''}`;
      console.log('Initiating Google OAuth...');
      console.log('Environment mode:', import.meta.env.MODE);
      console.log('Base URL:', baseUrl);
      const {data, error} = await supabase.auth.signInWithOAuth({
        provider: 'google',
        options: {
          // Add visible query param for robustness
          // flowType: 'pkce',
          redirectTo: `${baseUrl}/auth/callback?next=${encodeURIComponent(nextPath)}`,
          queryParams: {
            access_type: 'offline',
            prompt: 'consent',
          },
        },
      });

      if (error) {
        console.error('Google OAuth error:', error);
        throw error;
      }

      console.log('Google OAuth initiated successfully:', data);
      return data;
    } catch (err) {
      console.error('Unexpected error during Google OAuth:', err);
      throw err;
    }
  };

  const signOut = async () => {
    try {
      const {error} = await supabase.auth.signOut();
      if (error) throw error;
    } catch (err) {
      console.error('Error signing out:', err);
      throw err;
    }
  };

  return {
    signInWithGoogle,
    signOut,
    isDevelopment,
    baseUrl,
  };
};
