export const showNotification = (title: string, info: string, type: 'success' | 'error' | 'info') => {
  const toast = useToast();
  toast.add({
    title: title,
    description: info,
    color: type,
    icon: type == 'success' ? 'i-lucide-check-circle' : type == 'error' ? 'i-lucide-x-circle' : 'i-lucide-info',
  });
};
