export default defineNuxtRouteMiddleware(async (to, from) => {
  const roleHomepage: Record<string, string> = {
    admin: '/admin',
    organizer: '/organizer',
    user: '/user',
  };
  const toLiveRoom = to.name === 'user-liveroom-id';
  const toSignIn = to.name === 'auth-signin';
  if (toSignIn) return;
  const protectedSections = ['admin', 'organizer', 'user'];
  // The paths that are role-protected
  const protectedPath = protectedSections.find(section => to.path.startsWith(`/${section}`));
  const supabase = useSupabaseClient();
  const {data, error} = await supabase.auth.getSession();

  // if coockie 'palmyio' is expired
  const cookie = useCookie('palmyio').value || useCookie('palmyio.0').value;
  if (!cookie && protectedPath) {
    if (toLiveRoom) return await navigateTo('/r/' + to.params.id);
    return await redirectTo('/auth/signin', 'Line 20');
  }

  if (error || !data.session) {
    if (protectedPath && !toSignIn) {
      if (toLiveRoom) return await navigateTo('/r/' + to.params.id);
      return await redirectTo('/auth/signin', 'Line 27');
    }
    return;
  }
  try {
    const session = data.session;
    const user = useSupabaseUser().value;
    const role = user?.user_metadata?.role || 'user';
    const userHomePath = roleHomepage[role];

    // If a logged-in user hits any /auth route, send them to a sane default
    if (to.path.startsWith('/auth') && user?.id) {
      // Prefer explicit next path if provided
      const nextParam = (to.query?.next as string) || undefined;
      if (typeof nextParam === 'string' && nextParam.startsWith('/')) {
        return await navigateTo(nextParam);
      }
      return await navigateTo(userHomePath ?? '/user/');
    }

    if (!protectedPath)
      return; // Not a protected route, allow
    else if (!session) {
      await supabase.auth.signOut();
      return await redirectTo('/auth/signin', 'Line 49');
    }

    // Not logged in: send to login
    if (!user?.id) {
      await supabase.auth.signOut();
      return await redirectTo('/auth/signin', 'Line 55');
    }
    // Allow '/user' section even if role is not set yet (first-time social login)
    if (!role && protectedPath === 'user') return;
    // Missing role for non-user sections -> redirect to user profile by default
    if (!role) {
      return await redirectTo('/user/', 'Line 61');
    }
    // Allow '/user' section even if role is not set yet (first-time social login)
    if (!role && protectedPath === 'user') return;
    // Missing role for non-user sections -> redirect to user profile by default
    if (!role) return await navigateTo('/user/');

    // If the user's role does not match the section, redirect to their home
    if (protectedPath !== role && userHomePath) {
      return await redirectTo(userHomePath, 'Line 66');
    }
  } catch (error: unknown) {
    console.log(error);
    if (protectedPath && !toSignIn) {
      await supabase.auth.signOut();
      return await redirectTo('/auth/signin', 'Line 71');
    }
    return;
  }
});

async function redirectTo(path: string, msg?: string) {
  return await navigateTo(path);
}
