export interface ThemeColors {
  primary: string;
  secondary: string;
  darkPrimary: string;
  darkSecondary: string;
}

export default defineNuxtPlugin(() => {
  const theme = useState<ThemeColors | null>('theme', () => {
    if (import.meta.server) {
      const event = useRequestEvent();
      const userTheme = event?.context?.user?.theme;
      if (userTheme && typeof userTheme === 'object' && 'primary' in userTheme) {
        return userTheme as ThemeColors;
      }
    }
    return null;
  });

  if (theme.value) {
    const {primary, secondary, darkPrimary, darkSecondary} = theme.value;
    const dp = darkPrimary || primary;
    const ds = darkSecondary || secondary;

    // Only set source variables in <head> — CSS :root/.dark rules handle the swap
    useHead({
      script: [
        {
          innerHTML: [
            `document.documentElement.style.setProperty('--ui-light-primary','${primary}')`,
            `document.documentElement.style.setProperty('--ui-light-secondary','${secondary}')`,
            `document.documentElement.style.setProperty('--ui-dark-primary','${dp}')`,
            `document.documentElement.style.setProperty('--ui-dark-secondary','${ds}')`,
          ].join(';'),
          tagPosition: 'head',
        },
      ],
    });

    if (import.meta.client) {
      setTheme(primary, secondary, dp, ds);
    }
  }
});
