import withNuxt from './.nuxt/eslint.config.mjs';
import eslintConfigPrettier from 'eslint-config-prettier';

export default withNuxt({
  rules: {
    // Prettier handles attribute formatting
    'vue/first-attribute-linebreak': 'off',
    // Prettier handles wrapping; setting this prevents ESLint from forcing wraps
    'vue/max-attributes-per-line': 'off',
    'vue/multi-word-component-names': 'off',
  },
}).append(
  // Must be LAST to disable stylistic rules that conflict with Prettier
  eslintConfigPrettier
);
