// https://nuxt.com/docs/api/configuration/nuxt-config
export default defineNuxtConfig({
  modules: [
    '@nuxt/image',
    '@nuxt/eslint',
    '@nuxt/icon',
    '@nuxt/ui',
    '@nuxt/fonts',
    '@nuxtjs/supabase',
    'nuxt-gtag',
    'nuxt-qrcode',
  ],
  devtools: {enabled: true},
  css: ['~/assets/css/main.css'],
  colorMode: {preference: 'light'},
  runtimeConfig: {
    STRIPE_SECRET_KEY: process.env.STRIPE_SECRET_KEY,
    DOMAIN: process.env.DOMAIN,
    ENVIRONMENT: process.env.ENVIRONMENT || 'production',
    DATABASE_URL: process.env.DATABASE_URL,
    DIRECT_URL: process.env.DIRECT_URL,
    GOOGLE_API_KEY: process.env.GOOGLE_API_KEY,
    GOOGLE_CX_ID: process.env.GOOGLE_CX_ID,
    OPENAI_API_KEY: process.env.OPENAI_API_KEY,
    TWILIO_SID: process.env.TWILIO_SID,
    TWILIO_AUTH: process.env.TWILIO_AUTH,
    SUPABASE_SRV_ROLE: process.env.SUPABASE_SRV_ROLE,
    AWS_ACCESS_KEY_ID: process.env.AWS_ACCESS_KEY_ID,
    AWS_SECRET_ACCESS_KEY: process.env.AWS_SECRET_ACCESS_KEY,
    AWS_REGION: process.env.AWS_REGION,
    S3_BUCKET_NAME: process.env.S3_BUCKET_NAME,
    JWT_SECRET: process.env.JWT_SECRET,
    APPLE_TEAM_ID: process.env.APPLE_TEAM_ID,
    APPLE_PASS_TYPE_ID: process.env.APPLE_PASS_TYPE_ID,
    APPLE_PASS_CERT_PATH: process.env.APPLE_PASS_CERT_PATH,
    APPLE_PASS_CERT_PASSWORD: process.env.APPLE_PASS_CERT_PASSWORD,
    APPLE_WWDR_CERT_PATH: process.env.APPLE_WWDR_CERT_PATH,
    public: {
      BASE_URL: process.env.BASE_URL,
      GOOGLE_API_KEY: process.env.GOOGLE_API_KEY,
      GOOGLE_CX_ID: process.env.GOOGLE_CX_ID,
      SUPABASE_URL: process.env.SUPABASE_URL,
      SUPABASE_KEY: process.env.SUPABASE_KEY,
    },
  },
  build: {
    transpile: ['reka-ui', '@nuxt/ui'],
  },
  routeRules: {'/': {prerender: true}},
  devServer: {port: 3000},
  compatibilityDate: '2025-01-15',
  nitro: {
    esbuild: {
      options: {
        target: 'es2022',
      },
    },
  },
  vite: {
    build: {
      sourcemap: false,
      target: 'es2022',
    },
    optimizeDeps: {
      include: ['reka-ui', '@nuxt/ui'],
    },
  },
  eslint: {
    config: {
      stylistic: {
        commaDangle: 'never',
        braceStyle: '1tbs',
      },
    },
  },
  gtag: {id: 'GTM-KVFJMD6V'},
  image: {
    remote: {
      patterns: [{protocol: 'https', hostname: '**', port: '', pathname: '/**'}],
    },
  },
  supabase: {
    redirectOptions: {
      login: '/auth/signin',
      callback: '/auth/callback',
      exclude: [
        '/',
        '/auth/*',
        '/r/*',
        '/palmy',
        '/contest/*',
        '/fanphoto/*',
        '/api/public/*',
        '/return',
        '/live/*',
        '/ui',
      ],
    },
    cookiePrefix: 'palmyio',
    cookieOptions: {
      maxAge: 60 * 60 * 24 * 360,
    },
  },
});
