
/* !!! This is code generated by Prisma. Do not edit directly. !!!
/* eslint-disable */

Object.defineProperty(exports, "__esModule", { value: true });

const {
  PrismaClientKnownRequestError,
  PrismaClientUnknownRequestError,
  PrismaClientRustPanicError,
  PrismaClientInitializationError,
  PrismaClientValidationError,
  getPrismaClient,
  sqltag,
  empty,
  join,
  raw,
  skip,
  Decimal,
  Debug,
  objectEnumValues,
  makeStrictEnum,
  Extensions,
  warnOnce,
  defineDmmfProperty,
  Public,
  getRuntime,
  createParam,
} = require('./runtime/wasm-engine-edge.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 6.14.0
 * Query Engine version: 717184b7b35ea05dfa71a3236b7af656013e1e49
 */
Prisma.prismaVersion = {
  client: "6.14.0",
  engine: "717184b7b35ea05dfa71a3236b7af656013e1e49"
}

Prisma.PrismaClientKnownRequestError = PrismaClientKnownRequestError;
Prisma.PrismaClientUnknownRequestError = PrismaClientUnknownRequestError
Prisma.PrismaClientRustPanicError = PrismaClientRustPanicError
Prisma.PrismaClientInitializationError = PrismaClientInitializationError
Prisma.PrismaClientValidationError = PrismaClientValidationError
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = sqltag
Prisma.empty = empty
Prisma.join = join
Prisma.raw = raw
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = Extensions.getExtensionContext
Prisma.defineExtension = Extensions.defineExtension

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}





/**
 * Enums
 */
exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  ReadUncommitted: 'ReadUncommitted',
  ReadCommitted: 'ReadCommitted',
  RepeatableRead: 'RepeatableRead',
  Serializable: 'Serializable'
});

exports.Prisma.UserScalarFieldEnum = {
  id: 'id',
  uid: 'uid',
  username: 'username',
  type: 'type',
  firstName: 'firstName',
  lastName: 'lastName',
  orgName: 'orgName',
  address: 'address',
  city: 'city',
  state: 'state',
  zip: 'zip',
  photo: 'photo',
  email: 'email',
  bio: 'bio',
  isd: 'isd',
  phone: 'phone',
  approved: 'approved',
  raised: 'raised',
  file: 'file',
  otp: 'otp',
  themeColor: 'themeColor',
  theme: 'theme',
  verified: 'verified',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  permissions: 'permissions'
};

exports.Prisma.BankScalarFieldEnum = {
  id: 'id',
  name: 'name',
  account: 'account',
  routing: 'routing',
  stripeCustId: 'stripeCustId',
  stripeConnectId: 'stripeConnectId',
  userId: 'userId'
};

exports.Prisma.ContactScalarFieldEnum = {
  id: 'id',
  name: 'name',
  email: 'email',
  dob: 'dob',
  govId: 'govId',
  ssn: 'ssn',
  userId: 'userId'
};

exports.Prisma.SponsorScalarFieldEnum = {
  id: 'id',
  logo: 'logo',
  name: 'name',
  address: 'address',
  contactName: 'contactName',
  isd: 'isd',
  phone: 'phone',
  email: 'email',
  showInRoom: 'showInRoom',
  deleted: 'deleted',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  userId: 'userId'
};

exports.Prisma.CouponScalarFieldEnum = {
  id: 'id',
  logo: 'logo',
  name: 'name',
  description: 'description',
  urlText: 'urlText',
  url: 'url',
  code: 'code',
  photo: 'photo',
  expiry: 'expiry',
  deleted: 'deleted',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  userId: 'userId',
  sponsorId: 'sponsorId'
};

exports.Prisma.RedeemedScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  couponId: 'couponId',
  createdAt: 'createdAt'
};

exports.Prisma.ProjectScalarFieldEnum = {
  id: 'id',
  photos: 'photos',
  photo: 'photo',
  name: 'name',
  category: 'category',
  status: 'status',
  description: 'description',
  type: 'type',
  target: 'target',
  expiry: 'expiry',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  approved: 'approved',
  distribution: 'distribution',
  shared: 'shared',
  attendance: 'attendance',
  userId: 'userId',
  liveTitle: 'liveTitle',
  qrTitle: 'qrTitle',
  qrSubTitle: 'qrSubTitle',
  delayed: 'delayed',
  notify: 'notify',
  result: 'result',
  teamTag: 'teamTag',
  eventDate: 'eventDate',
  eventName: 'eventName'
};

exports.Prisma.DrawingScalarFieldEnum = {
  id: 'id',
  entries: 'entries',
  prize: 'prize',
  prizeType: 'prizeType',
  projectId: 'projectId'
};

exports.Prisma.DonationsScalarFieldEnum = {
  id: 'id',
  createdAt: 'createdAt',
  paymentId: 'paymentId',
  chargeId: 'chargeId',
  card: 'card',
  amount: 'amount',
  team: 'team',
  status: 'status',
  userId: 'userId',
  paidAt: 'paidAt',
  projectId: 'projectId',
  email: 'email'
};

exports.Prisma.FanPhotoScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  projectId: 'projectId',
  photo: 'photo',
  status: 'status',
  winner: 'winner',
  createdAt: 'createdAt'
};

exports.Prisma.ContestScalarFieldEnum = {
  id: 'id',
  question: 'question',
  image: 'image',
  projectId: 'projectId'
};

exports.Prisma.ContestAnswersScalarFieldEnum = {
  id: 'id',
  answer: 'answer',
  artist: 'artist',
  photoUrl: 'photoUrl',
  photo: 'photo',
  correct: 'correct',
  contestId: 'contestId'
};

exports.Prisma.GameScalarFieldEnum = {
  id: 'id',
  photo: 'photo',
  video: 'video',
  title: 'title',
  desc: 'desc',
  target: 'target',
  question: 'question',
  text: 'text',
  bingoType: 'bingoType',
  bingoActions: 'bingoActions',
  answer: 'answer',
  projectId: 'projectId',
  userId: 'userId'
};

exports.Prisma.GameEnterScalarFieldEnum = {
  id: 'id',
  section: 'section',
  seat: 'seat',
  row: 'row',
  fliped: 'fliped',
  answer: 'answer',
  playDone: 'playDone',
  projectId: 'projectId',
  userId: 'userId',
  winner: 'winner',
  gameId: 'gameId'
};

exports.Prisma.ContestEnterScalarFieldEnum = {
  id: 'id',
  answerId: 'answerId',
  userId: 'userId',
  contestId: 'contestId',
  projectId: 'projectId'
};

exports.Prisma.DrawingEnterScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  projectId: 'projectId',
  ticket: 'ticket',
  winner: 'winner'
};

exports.Prisma.LiveroomScalarFieldEnum = {
  id: 'id',
  active: 'active',
  songGameQr: 'songGameQr',
  songGameLive: 'songGameLive',
  comment: 'comment',
  scoreboard: 'scoreboard',
  headerImg: 'headerImg',
  headerTxt: 'headerTxt',
  headerFont: 'headerFont',
  headerSize: 'headerSize',
  headerBg: 'headerBg',
  headerColor: 'headerColor',
  bodyImg: 'bodyImg',
  bodyBg: 'bodyBg',
  bodyTxt: 'bodyTxt',
  bodySize: 'bodySize',
  bodyColor: 'bodyColor',
  bodyFont: 'bodyFont',
  popupBg: 'popupBg',
  popupColor: 'popupColor',
  fanPhBg: 'fanPhBg',
  fanPhColor: 'fanPhColor',
  fanPhLogo: 'fanPhLogo',
  fanPhTxt: 'fanPhTxt',
  fanPhDisplayId: 'fanPhDisplayId',
  contestDisplayId: 'contestDisplayId',
  pollBg: 'pollBg',
  pollBgColor: 'pollBgColor',
  pollColor: 'pollColor',
  pollResColor: 'pollResColor',
  pollLogo: 'pollLogo',
  pollTxt: 'pollTxt',
  userId: 'userId',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.FollowScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  organizationId: 'organizationId',
  createdAt: 'createdAt'
};

exports.Prisma.LikeScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  projectId: 'projectId',
  createdAt: 'createdAt'
};

exports.Prisma.CommentsScalarFieldEnum = {
  id: 'id',
  text: 'text',
  likes: 'likes',
  projectId: 'projectId',
  createdAt: 'createdAt'
};

exports.Prisma.ReplyScalarFieldEnum = {
  id: 'id',
  text: 'text',
  likes: 'likes',
  commentId: 'commentId',
  createdAt: 'createdAt'
};

exports.Prisma.NotificationScalarFieldEnum = {
  id: 'id',
  text: 'text',
  read: 'read',
  userId: 'userId',
  createdAt: 'createdAt'
};

exports.Prisma.TicketScalarFieldEnum = {
  id: 'id',
  name: 'name',
  email: 'email',
  phone: 'phone',
  help: 'help',
  message: 'message',
  createdAt: 'createdAt'
};

exports.Prisma.SettingsScalarFieldEnum = {
  id: 'id',
  key: 'key',
  value: 'value'
};

exports.Prisma.DisplayScalarFieldEnum = {
  id: 'id',
  logo: 'logo',
  name: 'name',
  width: 'width',
  height: 'height',
  userId: 'userId',
  createdAt: 'createdAt'
};

exports.Prisma.RosterSettingsScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  enabled: 'enabled',
  mode: 'mode',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.RosterTeamScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  side: 'side',
  logo: 'logo',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.RosterPlayerScalarFieldEnum = {
  id: 'id',
  teamId: 'teamId',
  number: 'number',
  name: 'name',
  position: 'position',
  class: 'class',
  height: 'height',
  hometown: 'hometown',
  bio: 'bio',
  photo: 'photo',
  order: 'order',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.TemplateScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  name: 'name',
  type: 'type',
  project: 'project'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.NullableJsonNullValueInput = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull
};

exports.Prisma.JsonNullValueInput = {
  JsonNull: Prisma.JsonNull
};

exports.Prisma.QueryMode = {
  default: 'default',
  insensitive: 'insensitive'
};

exports.Prisma.JsonNullValueFilter = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull,
  AnyNull: Prisma.AnyNull
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};
exports.UserType = exports.$Enums.UserType = {
  user: 'user',
  organizer: 'organizer'
};

exports.ProjectStatus = exports.$Enums.ProjectStatus = {
  queue: 'queue',
  live: 'live',
  completed: 'completed',
  archived: 'archived'
};

exports.ProjectCategory = exports.$Enums.ProjectCategory = {
  fundraiser: 'fundraiser',
  drawing: 'drawing',
  contest: 'contest',
  fanphoto: 'fanphoto',
  game: 'game'
};

exports.PaymentStatus = exports.$Enums.PaymentStatus = {
  pending: 'pending',
  paid: 'paid',
  failed: 'failed',
  refunded: 'refunded'
};

exports.RosterMode = exports.$Enums.RosterMode = {
  home: 'home',
  home_away: 'home_away'
};

exports.RosterSide = exports.$Enums.RosterSide = {
  home: 'home',
  away: 'away'
};

exports.Prisma.ModelName = {
  User: 'User',
  Bank: 'Bank',
  Contact: 'Contact',
  Sponsor: 'Sponsor',
  Coupon: 'Coupon',
  Redeemed: 'Redeemed',
  Project: 'Project',
  Drawing: 'Drawing',
  Donations: 'Donations',
  FanPhoto: 'FanPhoto',
  Contest: 'Contest',
  ContestAnswers: 'ContestAnswers',
  Game: 'Game',
  GameEnter: 'GameEnter',
  ContestEnter: 'ContestEnter',
  DrawingEnter: 'DrawingEnter',
  Liveroom: 'Liveroom',
  Follow: 'Follow',
  Like: 'Like',
  Comments: 'Comments',
  Reply: 'Reply',
  Notification: 'Notification',
  Ticket: 'Ticket',
  Settings: 'Settings',
  Display: 'Display',
  RosterSettings: 'RosterSettings',
  RosterTeam: 'RosterTeam',
  RosterPlayer: 'RosterPlayer',
  Template: 'Template'
};
/**
 * Create the Client
 */
const config = {
  "generator": {
    "name": "client",
    "provider": {
      "fromEnvVar": null,
      "value": "prisma-client-js"
    },
    "output": {
      "value": "/Users/mamunurrashid/Herd/palmy_aws/prisma/generated",
      "fromEnvVar": null
    },
    "config": {
      "engineType": "library"
    },
    "binaryTargets": [
      {
        "fromEnvVar": null,
        "value": "darwin-arm64",
        "native": true
      }
    ],
    "previewFeatures": [
      "driverAdapters"
    ],
    "sourceFilePath": "/Users/mamunurrashid/Herd/palmy_aws/prisma/schema.prisma",
    "isCustomOutput": true
  },
  "relativeEnvPaths": {
    "rootEnvPath": null,
    "schemaEnvPath": "../../.env"
  },
  "relativePath": "..",
  "clientVersion": "6.14.0",
  "engineVersion": "717184b7b35ea05dfa71a3236b7af656013e1e49",
  "datasourceNames": [
    "db"
  ],
  "activeProvider": "postgresql",
  "postinstall": false,
  "inlineDatasources": {
    "db": {
      "url": {
        "fromEnvVar": "DATABASE_URL",
        "value": null
      }
    }
  },
  "inlineSchema": "generator client {\n  provider        = \"prisma-client-js\"\n  output          = \"./generated\"\n  previewFeatures = [\"driverAdapters\"]\n}\n\ndatasource db {\n  provider  = \"postgresql\"\n  url       = env(\"DATABASE_URL\")\n  directUrl = env(\"DIRECT_URL\")\n}\n\nmodel User {\n  id             Int             @id @default(autoincrement())\n  uid            String          @unique @db.Uuid\n  username       String?         @unique\n  type           UserType        @default(user)\n  firstName      String?\n  lastName       String?\n  orgName        String?\n  address        String?\n  city           String?\n  state          String?\n  zip            String?\n  photo          String?\n  email          String?         @unique\n  bio            String?\n  isd            String?\n  phone          String?         @unique\n  approved       Boolean?\n  raised         Int?\n  file           String?\n  otp            Int?\n  themeColor     String?\n  theme          Json?\n  verified       Boolean         @default(false)\n  createdAt      DateTime        @default(now())\n  updatedAt      DateTime        @updatedAt\n  permissions    Json?\n  bank           Bank?\n  contact        Contact?\n  liveroom       Liveroom?\n  following      Follow[]        @relation(\"by\")\n  followers      Follow[]        @relation(\"to\")\n  sponsors       Sponsor[]\n  coupons        Coupon[]\n  projects       Project[]\n  likes          Like[]\n  notifications  Notification[]\n  redeemed       Redeemed[]\n  answers        ContestEnter[]\n  gameEnters     GameEnter[]\n  drawingEnter   DrawingEnter[]\n  fanPhoto       FanPhoto[]\n  displays       Display[]\n  game           Game[]\n  rosterSettings RosterSettings?\n  rosterTeams    RosterTeam[]\n  Template       Template[]\n  donations      Donations[]\n\n  @@index([uid])\n}\n\nmodel Bank {\n  id              Int     @id @default(autoincrement())\n  name            String?\n  account         String?\n  routing         String?\n  stripeCustId    String?\n  stripeConnectId String?\n  userId          Int     @unique\n  user            User    @relation(fields: [userId], references: [id], onDelete: Cascade)\n}\n\nmodel Contact {\n  id     Int       @id @default(autoincrement())\n  name   String?\n  email  String?\n  dob    DateTime?\n  govId  String?\n  ssn    String?\n  userId Int       @unique\n  user   User      @relation(fields: [userId], references: [id], onDelete: Cascade)\n}\n\nenum UserType {\n  user\n  organizer\n}\n\nmodel Sponsor {\n  id          Int       @id @default(autoincrement())\n  logo        String\n  name        String\n  address     String\n  contactName String\n  isd         String?\n  phone       String?\n  email       String\n  showInRoom  Boolean   @default(false)\n  deleted     Boolean   @default(false)\n  createdAt   DateTime  @default(now())\n  updatedAt   DateTime  @updatedAt\n  userId      Int\n  user        User      @relation(fields: [userId], references: [id], onDelete: Cascade)\n  projects    Project[]\n  coupons     Coupon[]\n\n  @@index([userId])\n}\n\nmodel Coupon {\n  id          Int        @id @default(autoincrement())\n  logo        String\n  name        String\n  description String\n  urlText     String?\n  url         String?\n  code        String?\n  photo       String?\n  expiry      DateTime?\n  deleted     Boolean    @default(false)\n  createdAt   DateTime   @default(now())\n  updatedAt   DateTime   @updatedAt\n  userId      Int\n  user        User       @relation(fields: [userId], references: [id], onDelete: Cascade)\n  sponsor     Sponsor    @relation(fields: [sponsorId], references: [id], onDelete: Cascade)\n  sponsorId   Int\n  redeemed    Redeemed[]\n  projects    Project[]\n\n  @@index([userId])\n  @@index([sponsorId])\n}\n\nmodel Redeemed {\n  id        Int      @id @default(autoincrement())\n  userId    Int\n  couponId  Int\n  createdAt DateTime @default(now())\n  coupon    Coupon   @relation(fields: [couponId], references: [id], onDelete: Cascade)\n  user      User     @relation(fields: [userId], references: [id], onDelete: Cascade)\n\n  @@index([userId])\n  @@index([couponId])\n}\n\nmodel Project {\n  id           Int             @id @default(autoincrement())\n  photos       Json\n  photo        String?\n  name         String\n  category     ProjectCategory\n  status       ProjectStatus\n  description  String?\n  type         String?\n  target       Int?            @default(1)\n  expiry       DateTime?\n  createdAt    DateTime        @default(now())\n  updatedAt    DateTime        @updatedAt\n  approved     Boolean?\n  distribution String?\n  shared       Int?            @default(0)\n  attendance   Int?            @default(0)\n  userId       Int\n  liveTitle    String?\n  qrTitle      String?\n  qrSubTitle   String?\n  delayed      Boolean         @default(false)\n  notify       Boolean         @default(true)\n  result       String?\n  teamTag      String?\n  eventDate    DateTime?       @db.Timestamptz(6)\n  eventName    String?\n  comments     Comments[]\n  contests     Contest[]\n  contestEnter ContestEnter[]\n  drawing      Drawing?\n  drawingEnter DrawingEnter[]\n  fanPhoto     FanPhoto[]\n  donations    Donations[]\n  game         Game[]\n  gameEnter    GameEnter[]\n  likes        Like[]\n  user         User            @relation(fields: [userId], references: [id], onDelete: Cascade)\n  coupons      Coupon[]\n  sponsors     Sponsor[]\n\n  @@index([userId])\n}\n\nenum ProjectStatus {\n  queue\n  live\n  completed\n  archived\n}\n\nenum ProjectCategory {\n  fundraiser\n  drawing\n  contest\n  fanphoto\n  game\n}\n\nmodel Drawing {\n  id        Int     @id @default(autoincrement())\n  entries   Json?\n  prize     String\n  prizeType String\n  projectId Int     @unique\n  project   Project @relation(fields: [projectId], references: [id], onDelete: Cascade)\n}\n\nenum PaymentStatus {\n  pending\n  paid\n  failed\n  refunded\n}\n\nmodel Donations {\n  id        Int           @id @default(autoincrement())\n  createdAt DateTime      @default(now())\n  paymentId String        @unique\n  chargeId  String?       @unique\n  card      String?\n  amount    Int\n  team      String?\n  status    PaymentStatus\n  userId    Int?\n  paidAt    DateTime?\n  projectId Int\n  email     String?\n  project   Project       @relation(fields: [projectId], references: [id])\n  user      User?         @relation(fields: [userId], references: [id])\n}\n\nmodel FanPhoto {\n  id        Int      @id @default(autoincrement())\n  userId    Int\n  projectId Int\n  photo     String\n  status    String\n  winner    Boolean  @default(false)\n  createdAt DateTime @default(now())\n  project   Project  @relation(fields: [projectId], references: [id], onDelete: Cascade)\n  user      User     @relation(fields: [userId], references: [id], onDelete: Cascade)\n\n  @@index([projectId])\n  @@index([userId])\n}\n\nmodel Contest {\n  id           Int              @id @default(autoincrement())\n  question     String\n  image        String           @default(\"\")\n  projectId    Int\n  project      Project          @relation(fields: [projectId], references: [id], onDelete: Cascade)\n  answers      ContestAnswers[]\n  participants ContestEnter[]\n\n  @@index([projectId])\n}\n\nmodel ContestAnswers {\n  id           Int            @id @default(autoincrement())\n  answer       String\n  artist       String?\n  photoUrl     String?\n  photo        String?\n  correct      Boolean?\n  contestId    Int\n  contest      Contest        @relation(fields: [contestId], references: [id], onDelete: Cascade)\n  participants ContestEnter[]\n\n  @@index([contestId])\n}\n\nmodel Game {\n  id           Int         @id @default(autoincrement())\n  photo        String?\n  video        String?\n  title        String?\n  desc         String?\n  target       Int?        @default(0)\n  question     String? // @deprecated(\"Use 'desc' instead\")\n  text         String? // @deprecated(\"Use 'title' instead\")\n  bingoType    String?\n  bingoActions Json?\n  answer       Int?        @default(0)\n  projectId    Int\n  userId       Int\n  project      Project     @relation(fields: [projectId], references: [id], onDelete: Cascade)\n  user         User        @relation(fields: [userId], references: [id], onDelete: Cascade)\n  participants GameEnter[]\n\n  @@index([userId])\n  @@index([projectId])\n}\n\nmodel GameEnter {\n  id        Int     @id @default(autoincrement())\n  section   String?\n  seat      String?\n  row       String?\n  fliped    Json?\n  answer    Int?\n  playDone  Boolean @default(false)\n  projectId Int\n  userId    Int\n  winner    Boolean @default(false)\n  gameId    Int\n  game      Game    @relation(fields: [gameId], references: [id], onDelete: Cascade)\n  project   Project @relation(fields: [projectId], references: [id], onDelete: Cascade)\n  user      User    @relation(fields: [userId], references: [id], onDelete: Cascade)\n\n  @@unique([projectId, userId, gameId])\n  @@index([projectId])\n  @@index([userId])\n  @@index([gameId])\n}\n\nmodel ContestEnter {\n  id        Int            @id @default(autoincrement())\n  answerId  Int\n  userId    Int\n  contestId Int\n  projectId Int\n  answer    ContestAnswers @relation(fields: [answerId], references: [id], onDelete: Cascade)\n  contest   Contest        @relation(fields: [contestId], references: [id], onDelete: Cascade)\n  project   Project        @relation(fields: [projectId], references: [id], onDelete: Cascade)\n  user      User           @relation(fields: [userId], references: [id], onDelete: Cascade)\n\n  @@index([answerId])\n  @@index([userId])\n  @@index([contestId])\n  @@index([projectId])\n}\n\nmodel DrawingEnter {\n  id        Int     @id @default(autoincrement())\n  userId    Int\n  projectId Int\n  ticket    String\n  winner    Boolean @default(false)\n  project   Project @relation(fields: [projectId], references: [id], onDelete: Cascade)\n  user      User    @relation(fields: [userId], references: [id], onDelete: Cascade)\n\n  @@index([userId])\n  @@index([projectId])\n}\n\nmodel Liveroom {\n  id               Int      @id @default(autoincrement())\n  active           Boolean  @default(false)\n  songGameQr       Json?\n  songGameLive     Json?\n  comment          Boolean  @default(false)\n  scoreboard       Boolean  @default(false)\n  headerImg        String   @default(\"\")\n  headerTxt        String   @default(\"\")\n  headerFont       String   @default(\"\")\n  headerSize       Int      @default(16)\n  headerBg         String   @default(\"\")\n  headerColor      String   @default(\"\")\n  bodyImg          String   @default(\"\")\n  bodyBg           String   @default(\"\")\n  bodyTxt          String   @default(\"\")\n  bodySize         Int      @default(16)\n  bodyColor        String   @default(\"\")\n  bodyFont         String   @default(\"\")\n  popupBg          String   @default(\"\")\n  popupColor       String   @default(\"\")\n  fanPhBg          String   @default(\"\")\n  fanPhColor       String   @default(\"\")\n  fanPhLogo        String   @default(\"\")\n  fanPhTxt         String   @default(\"\")\n  fanPhDisplayId   Int?\n  contestDisplayId Int?\n  pollBg           String   @default(\"\")\n  pollBgColor      String   @default(\"\")\n  pollColor        String   @default(\"\")\n  pollResColor     String   @default(\"\")\n  pollLogo         String   @default(\"\")\n  pollTxt          String   @default(\"\")\n  userId           Int      @unique\n  createdAt        DateTime @default(now())\n  updatedAt        DateTime @updatedAt\n  contestDisplay   Display? @relation(\"ContestDisplay\", fields: [contestDisplayId], references: [id], onDelete: Cascade)\n  fanPhDisplay     Display? @relation(\"FanPhDisplay\", fields: [fanPhDisplayId], references: [id], onDelete: Cascade)\n  user             User     @relation(fields: [userId], references: [id], onDelete: Cascade)\n\n  @@index([userId])\n  @@index([fanPhDisplayId])\n  @@index([contestDisplayId])\n}\n\nmodel Follow {\n  id             Int      @id @default(autoincrement())\n  userId         Int\n  organizationId Int\n  createdAt      DateTime @default(now())\n  organization   User     @relation(\"to\", fields: [organizationId], references: [id], onDelete: Cascade)\n  user           User     @relation(\"by\", fields: [userId], references: [id], onDelete: Cascade)\n\n  @@index([userId])\n  @@index([organizationId])\n}\n\nmodel Like {\n  id        Int      @id @default(autoincrement())\n  userId    Int\n  projectId Int\n  createdAt DateTime @default(now())\n  project   Project  @relation(fields: [projectId], references: [id], onDelete: Cascade)\n  user      User     @relation(fields: [userId], references: [id], onDelete: Cascade)\n\n  @@index([userId])\n  @@index([projectId])\n}\n\nmodel Comments {\n  id        Int      @id @default(autoincrement())\n  text      String\n  likes     Int\n  projectId Int\n  createdAt DateTime @default(now())\n  project   Project  @relation(fields: [projectId], references: [id], onDelete: Cascade)\n  Reply     Reply[]\n\n  @@index([projectId])\n}\n\nmodel Reply {\n  id        Int      @id @default(autoincrement())\n  text      String\n  likes     Int\n  commentId Int\n  createdAt DateTime @default(now())\n  comment   Comments @relation(fields: [commentId], references: [id], onDelete: Cascade)\n\n  @@index([commentId])\n}\n\nmodel Notification {\n  id        Int      @id @default(autoincrement())\n  text      String\n  read      Boolean\n  userId    Int\n  createdAt DateTime @default(now())\n  user      User     @relation(fields: [userId], references: [id], onDelete: Cascade)\n\n  @@index([userId])\n}\n\nmodel Ticket {\n  id        Int      @id @default(autoincrement())\n  name      String\n  email     String\n  phone     String\n  help      String\n  message   String\n  createdAt DateTime @default(now())\n}\n\nmodel Settings {\n  id    Int    @id @default(autoincrement())\n  key   String @unique\n  value String\n\n  @@index([key])\n}\n\nmodel Display {\n  id               Int        @id @default(autoincrement())\n  logo             String?\n  name             String\n  width            Int\n  height           Int\n  userId           Int\n  createdAt        DateTime   @default(now())\n  user             User       @relation(fields: [userId], references: [id], onDelete: Cascade)\n  contestLiverooms Liveroom[] @relation(\"ContestDisplay\")\n  fanPhLiverooms   Liveroom[] @relation(\"FanPhDisplay\")\n\n  @@index([userId])\n}\n\n/// Roster feature\n\nenum RosterMode {\n  home\n  home_away\n}\n\nenum RosterSide {\n  home\n  away\n}\n\nmodel RosterSettings {\n  id        Int        @id @default(autoincrement())\n  userId    Int        @unique\n  user      User       @relation(fields: [userId], references: [id], onDelete: Cascade)\n  enabled   Boolean    @default(false)\n  mode      RosterMode @default(home)\n  createdAt DateTime   @default(now())\n  updatedAt DateTime   @updatedAt\n}\n\nmodel RosterTeam {\n  id        Int            @id @default(autoincrement())\n  userId    Int\n  user      User           @relation(fields: [userId], references: [id], onDelete: Cascade)\n  side      RosterSide\n  logo      String?\n  createdAt DateTime       @default(now())\n  updatedAt DateTime       @default(now())\n  players   RosterPlayer[]\n\n  @@unique([userId, side])\n  @@index([userId])\n}\n\nmodel RosterPlayer {\n  id        Int        @id @default(autoincrement())\n  teamId    Int\n  team      RosterTeam @relation(fields: [teamId], references: [id], onDelete: Cascade)\n  number    Int?\n  name      String\n  position  String?\n  class     String?\n  height    String?\n  hometown  String?\n  bio       String?\n  photo     String?\n  order     Int        @default(0)\n  createdAt DateTime   @default(now())\n  updatedAt DateTime   @updatedAt\n\n  @@index([teamId])\n}\n\nmodel Template {\n  id      Int     @id @default(autoincrement())\n  userId  Int\n  user    User    @relation(fields: [userId], references: [id], onDelete: Cascade)\n  name    String?\n  type    String?\n  project Json?\n\n  @@index([userId])\n}\n",
  "inlineSchemaHash": "895e69f262f64673cf26e498c2f4470de71a9cba2ced18ec7e7dfa59ec2caa74",
  "copyEngine": true
}
config.dirname = '/'

config.runtimeDataModel = JSON.parse("{\"models\":{\"User\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"uid\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"username\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"type\",\"kind\":\"enum\",\"type\":\"UserType\"},{\"name\":\"firstName\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"lastName\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"orgName\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"address\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"city\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"state\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"zip\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"photo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"email\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"bio\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"isd\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"phone\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"approved\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"raised\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"file\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"otp\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"themeColor\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"theme\",\"kind\":\"scalar\",\"type\":\"Json\"},{\"name\":\"verified\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"permissions\",\"kind\":\"scalar\",\"type\":\"Json\"},{\"name\":\"bank\",\"kind\":\"object\",\"type\":\"Bank\",\"relationName\":\"BankToUser\"},{\"name\":\"contact\",\"kind\":\"object\",\"type\":\"Contact\",\"relationName\":\"ContactToUser\"},{\"name\":\"liveroom\",\"kind\":\"object\",\"type\":\"Liveroom\",\"relationName\":\"LiveroomToUser\"},{\"name\":\"following\",\"kind\":\"object\",\"type\":\"Follow\",\"relationName\":\"by\"},{\"name\":\"followers\",\"kind\":\"object\",\"type\":\"Follow\",\"relationName\":\"to\"},{\"name\":\"sponsors\",\"kind\":\"object\",\"type\":\"Sponsor\",\"relationName\":\"SponsorToUser\"},{\"name\":\"coupons\",\"kind\":\"object\",\"type\":\"Coupon\",\"relationName\":\"CouponToUser\"},{\"name\":\"projects\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"ProjectToUser\"},{\"name\":\"likes\",\"kind\":\"object\",\"type\":\"Like\",\"relationName\":\"LikeToUser\"},{\"name\":\"notifications\",\"kind\":\"object\",\"type\":\"Notification\",\"relationName\":\"NotificationToUser\"},{\"name\":\"redeemed\",\"kind\":\"object\",\"type\":\"Redeemed\",\"relationName\":\"RedeemedToUser\"},{\"name\":\"answers\",\"kind\":\"object\",\"type\":\"ContestEnter\",\"relationName\":\"ContestEnterToUser\"},{\"name\":\"gameEnters\",\"kind\":\"object\",\"type\":\"GameEnter\",\"relationName\":\"GameEnterToUser\"},{\"name\":\"drawingEnter\",\"kind\":\"object\",\"type\":\"DrawingEnter\",\"relationName\":\"DrawingEnterToUser\"},{\"name\":\"fanPhoto\",\"kind\":\"object\",\"type\":\"FanPhoto\",\"relationName\":\"FanPhotoToUser\"},{\"name\":\"displays\",\"kind\":\"object\",\"type\":\"Display\",\"relationName\":\"DisplayToUser\"},{\"name\":\"game\",\"kind\":\"object\",\"type\":\"Game\",\"relationName\":\"GameToUser\"},{\"name\":\"rosterSettings\",\"kind\":\"object\",\"type\":\"RosterSettings\",\"relationName\":\"RosterSettingsToUser\"},{\"name\":\"rosterTeams\",\"kind\":\"object\",\"type\":\"RosterTeam\",\"relationName\":\"RosterTeamToUser\"},{\"name\":\"Template\",\"kind\":\"object\",\"type\":\"Template\",\"relationName\":\"TemplateToUser\"},{\"name\":\"donations\",\"kind\":\"object\",\"type\":\"Donations\",\"relationName\":\"DonationsToUser\"}],\"dbName\":null},\"Bank\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"account\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"routing\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"stripeCustId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"stripeConnectId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"BankToUser\"}],\"dbName\":null},\"Contact\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"email\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"dob\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"govId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"ssn\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"ContactToUser\"}],\"dbName\":null},\"Sponsor\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"logo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"address\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"contactName\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"isd\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"phone\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"email\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"showInRoom\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"deleted\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"SponsorToUser\"},{\"name\":\"projects\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"ProjectToSponsor\"},{\"name\":\"coupons\",\"kind\":\"object\",\"type\":\"Coupon\",\"relationName\":\"CouponToSponsor\"}],\"dbName\":null},\"Coupon\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"logo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"description\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"urlText\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"url\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"code\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"photo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"expiry\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"deleted\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"CouponToUser\"},{\"name\":\"sponsor\",\"kind\":\"object\",\"type\":\"Sponsor\",\"relationName\":\"CouponToSponsor\"},{\"name\":\"sponsorId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"redeemed\",\"kind\":\"object\",\"type\":\"Redeemed\",\"relationName\":\"CouponToRedeemed\"},{\"name\":\"projects\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"CouponToProject\"}],\"dbName\":null},\"Redeemed\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"couponId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"coupon\",\"kind\":\"object\",\"type\":\"Coupon\",\"relationName\":\"CouponToRedeemed\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"RedeemedToUser\"}],\"dbName\":null},\"Project\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"photos\",\"kind\":\"scalar\",\"type\":\"Json\"},{\"name\":\"photo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"category\",\"kind\":\"enum\",\"type\":\"ProjectCategory\"},{\"name\":\"status\",\"kind\":\"enum\",\"type\":\"ProjectStatus\"},{\"name\":\"description\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"type\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"target\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"expiry\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"approved\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"distribution\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"shared\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"attendance\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"liveTitle\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"qrTitle\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"qrSubTitle\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"delayed\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"notify\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"result\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"teamTag\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"eventDate\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"eventName\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"comments\",\"kind\":\"object\",\"type\":\"Comments\",\"relationName\":\"CommentsToProject\"},{\"name\":\"contests\",\"kind\":\"object\",\"type\":\"Contest\",\"relationName\":\"ContestToProject\"},{\"name\":\"contestEnter\",\"kind\":\"object\",\"type\":\"ContestEnter\",\"relationName\":\"ContestEnterToProject\"},{\"name\":\"drawing\",\"kind\":\"object\",\"type\":\"Drawing\",\"relationName\":\"DrawingToProject\"},{\"name\":\"drawingEnter\",\"kind\":\"object\",\"type\":\"DrawingEnter\",\"relationName\":\"DrawingEnterToProject\"},{\"name\":\"fanPhoto\",\"kind\":\"object\",\"type\":\"FanPhoto\",\"relationName\":\"FanPhotoToProject\"},{\"name\":\"donations\",\"kind\":\"object\",\"type\":\"Donations\",\"relationName\":\"DonationsToProject\"},{\"name\":\"game\",\"kind\":\"object\",\"type\":\"Game\",\"relationName\":\"GameToProject\"},{\"name\":\"gameEnter\",\"kind\":\"object\",\"type\":\"GameEnter\",\"relationName\":\"GameEnterToProject\"},{\"name\":\"likes\",\"kind\":\"object\",\"type\":\"Like\",\"relationName\":\"LikeToProject\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"ProjectToUser\"},{\"name\":\"coupons\",\"kind\":\"object\",\"type\":\"Coupon\",\"relationName\":\"CouponToProject\"},{\"name\":\"sponsors\",\"kind\":\"object\",\"type\":\"Sponsor\",\"relationName\":\"ProjectToSponsor\"}],\"dbName\":null},\"Drawing\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"entries\",\"kind\":\"scalar\",\"type\":\"Json\"},{\"name\":\"prize\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"prizeType\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"projectId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"project\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"DrawingToProject\"}],\"dbName\":null},\"Donations\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"paymentId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"chargeId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"card\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"amount\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"team\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"status\",\"kind\":\"enum\",\"type\":\"PaymentStatus\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"paidAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"projectId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"email\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"project\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"DonationsToProject\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"DonationsToUser\"}],\"dbName\":null},\"FanPhoto\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"projectId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"photo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"status\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"winner\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"project\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"FanPhotoToProject\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"FanPhotoToUser\"}],\"dbName\":null},\"Contest\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"question\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"image\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"projectId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"project\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"ContestToProject\"},{\"name\":\"answers\",\"kind\":\"object\",\"type\":\"ContestAnswers\",\"relationName\":\"ContestToContestAnswers\"},{\"name\":\"participants\",\"kind\":\"object\",\"type\":\"ContestEnter\",\"relationName\":\"ContestToContestEnter\"}],\"dbName\":null},\"ContestAnswers\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"answer\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"artist\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"photoUrl\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"photo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"correct\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"contestId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"contest\",\"kind\":\"object\",\"type\":\"Contest\",\"relationName\":\"ContestToContestAnswers\"},{\"name\":\"participants\",\"kind\":\"object\",\"type\":\"ContestEnter\",\"relationName\":\"ContestAnswersToContestEnter\"}],\"dbName\":null},\"Game\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"photo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"video\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"title\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"desc\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"target\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"question\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"text\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"bingoType\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"bingoActions\",\"kind\":\"scalar\",\"type\":\"Json\"},{\"name\":\"answer\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"projectId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"project\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"GameToProject\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"GameToUser\"},{\"name\":\"participants\",\"kind\":\"object\",\"type\":\"GameEnter\",\"relationName\":\"GameToGameEnter\"}],\"dbName\":null},\"GameEnter\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"section\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"seat\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"row\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"fliped\",\"kind\":\"scalar\",\"type\":\"Json\"},{\"name\":\"answer\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"playDone\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"projectId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"winner\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"gameId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"game\",\"kind\":\"object\",\"type\":\"Game\",\"relationName\":\"GameToGameEnter\"},{\"name\":\"project\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"GameEnterToProject\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"GameEnterToUser\"}],\"dbName\":null},\"ContestEnter\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"answerId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"contestId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"projectId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"answer\",\"kind\":\"object\",\"type\":\"ContestAnswers\",\"relationName\":\"ContestAnswersToContestEnter\"},{\"name\":\"contest\",\"kind\":\"object\",\"type\":\"Contest\",\"relationName\":\"ContestToContestEnter\"},{\"name\":\"project\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"ContestEnterToProject\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"ContestEnterToUser\"}],\"dbName\":null},\"DrawingEnter\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"projectId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"ticket\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"winner\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"project\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"DrawingEnterToProject\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"DrawingEnterToUser\"}],\"dbName\":null},\"Liveroom\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"active\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"songGameQr\",\"kind\":\"scalar\",\"type\":\"Json\"},{\"name\":\"songGameLive\",\"kind\":\"scalar\",\"type\":\"Json\"},{\"name\":\"comment\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"scoreboard\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"headerImg\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"headerTxt\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"headerFont\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"headerSize\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"headerBg\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"headerColor\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"bodyImg\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"bodyBg\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"bodyTxt\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"bodySize\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"bodyColor\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"bodyFont\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"popupBg\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"popupColor\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"fanPhBg\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"fanPhColor\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"fanPhLogo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"fanPhTxt\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"fanPhDisplayId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"contestDisplayId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"pollBg\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"pollBgColor\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"pollColor\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"pollResColor\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"pollLogo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"pollTxt\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"contestDisplay\",\"kind\":\"object\",\"type\":\"Display\",\"relationName\":\"ContestDisplay\"},{\"name\":\"fanPhDisplay\",\"kind\":\"object\",\"type\":\"Display\",\"relationName\":\"FanPhDisplay\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"LiveroomToUser\"}],\"dbName\":null},\"Follow\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"organizationId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"organization\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"to\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"by\"}],\"dbName\":null},\"Like\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"projectId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"project\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"LikeToProject\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"LikeToUser\"}],\"dbName\":null},\"Comments\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"text\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"likes\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"projectId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"project\",\"kind\":\"object\",\"type\":\"Project\",\"relationName\":\"CommentsToProject\"},{\"name\":\"Reply\",\"kind\":\"object\",\"type\":\"Reply\",\"relationName\":\"CommentsToReply\"}],\"dbName\":null},\"Reply\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"text\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"likes\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"commentId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"comment\",\"kind\":\"object\",\"type\":\"Comments\",\"relationName\":\"CommentsToReply\"}],\"dbName\":null},\"Notification\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"text\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"read\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"NotificationToUser\"}],\"dbName\":null},\"Ticket\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"email\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"phone\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"help\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"message\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":null},\"Settings\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"key\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"value\",\"kind\":\"scalar\",\"type\":\"String\"}],\"dbName\":null},\"Display\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"logo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"width\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"height\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"DisplayToUser\"},{\"name\":\"contestLiverooms\",\"kind\":\"object\",\"type\":\"Liveroom\",\"relationName\":\"ContestDisplay\"},{\"name\":\"fanPhLiverooms\",\"kind\":\"object\",\"type\":\"Liveroom\",\"relationName\":\"FanPhDisplay\"}],\"dbName\":null},\"RosterSettings\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"RosterSettingsToUser\"},{\"name\":\"enabled\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"mode\",\"kind\":\"enum\",\"type\":\"RosterMode\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":null},\"RosterTeam\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"RosterTeamToUser\"},{\"name\":\"side\",\"kind\":\"enum\",\"type\":\"RosterSide\"},{\"name\":\"logo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"players\",\"kind\":\"object\",\"type\":\"RosterPlayer\",\"relationName\":\"RosterPlayerToRosterTeam\"}],\"dbName\":null},\"RosterPlayer\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"teamId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"team\",\"kind\":\"object\",\"type\":\"RosterTeam\",\"relationName\":\"RosterPlayerToRosterTeam\"},{\"name\":\"number\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"position\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"class\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"height\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"hometown\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"bio\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"photo\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"order\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":null},\"Template\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"TemplateToUser\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"type\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"project\",\"kind\":\"scalar\",\"type\":\"Json\"}],\"dbName\":null}},\"enums\":{},\"types\":{}}")
defineDmmfProperty(exports.Prisma, config.runtimeDataModel)
config.engineWasm = {
  getRuntime: async () => require('./query_engine_bg.js'),
  getQueryEngineWasmModule: async () => {
    const loader = (await import('#wasm-engine-loader')).default
    const engine = (await loader).default
    return engine
  }
}
config.compilerWasm = undefined

config.injectableEdgeEnv = () => ({
  parsed: {
    DATABASE_URL: typeof globalThis !== 'undefined' && globalThis['DATABASE_URL'] || typeof process !== 'undefined' && process.env && process.env.DATABASE_URL || undefined
  }
})

if (typeof globalThis !== 'undefined' && globalThis['DEBUG'] || typeof process !== 'undefined' && process.env && process.env.DEBUG || undefined) {
  Debug.enable(typeof globalThis !== 'undefined' && globalThis['DEBUG'] || typeof process !== 'undefined' && process.env && process.env.DEBUG || undefined)
}

const PrismaClient = getPrismaClient(config)
exports.PrismaClient = PrismaClient
Object.assign(exports, Prisma)

