export default defineEventHandler(async (event) => {
  const [projects, users, organizers] = await Promise.all([prisma.project.count(), prisma.user.count({ where: { type: 'user' as const } }), prisma.user.count({ where: { type: 'organizer' as const } })]);

  return {
    status: true,
    data: {
      projects,
      users,
      organizers,
    },
  };
});
