export default defineEventHandler(async (event) => {
  const method = event.method;
  const query = getQuery(event);
  const page = Number(query.page) || 1;
  const limit = Number(query.limit) || 10;
  const search = query.search || '';
  const status = query.status || 'All';
  const skip = (page - 1) * limit;
  const take = limit;

  const where = {
    AND: [
      { OR: [{ approved: null }, { approved: true }, { approved: false }] },
      {
        OR: [{ name: { contains: String(search) } }, { user: { orgName: { contains: String(search) } } }],
      },
    ],
  };
  if (status == 'Approved') {
    where.AND[0].OR = [{ approved: true }];
  } else if (status == 'Rejected') {
    where.AND[0].OR = [{ approved: false }];
  } else if (status == 'Pending') {
    where.AND[0].OR = [{ approved: null }];
  }

  if (method == 'GET') {
    return prisma.project
      .findMany({
        where,
        select: {
          id: true,
          name: true,
          type: true,
          category: true,
          status: true,
          approved: true,
          user: {
            select: {
              orgName: true,
              email: true,
            },
          },
          createdAt: true,
        },
        orderBy: {
          createdAt: 'desc',
        },
        skip: skip,
        take: take,
      })
      .then(async (data) => {
        const totalCount = await prisma.project.count({
          where,
        });
        return {
          data,
          total: totalCount,
          pages: Math.ceil(totalCount / limit),
        };
      });
  }
});
