export default defineEventHandler(async (event) => {
  const method = event.method;
  if (method == 'POST') {
    const formData = await readFormData(event);
    const pollPrompt = formData.get('pollPrompt') as string;
    const triviaPrompt = formData.get('triviaPrompt') as string;
    return await prisma
      .$transaction([
        prisma.settings.update({
          where: { key: 'pollPrompt' },
          data: { value: pollPrompt },
        }),
        prisma.settings.update({
          where: { key: 'triviaPrompt' },
          data: { value: triviaPrompt },
        }),
      ])
      .then(() => {
        return { status: true, message: 'Settings updated successfully' };
      })
      .catch((error) => {
        console.error('Error updating settings:', error);
        return { status: false, message: 'Failed to update settings' };
      });
  }
});
