export default defineEventHandler(async (event) => {
  const method = event.method;
  if (method == 'GET') {
    return await prisma.settings
      .findMany({
        where: {
          key: {
            in: ['userSignup', 'orgSignup', 'pollPrompt', 'triviaPrompt', 'signup'],
          },
        },
        select: { key: true, value: true },
      })
      .then((res) => {
        if (!res) {
          return { status: false, value: '{}' };
        }
        let data = {
          pollPrompt: '',
          triviaPrompt: '',
          userSignup: false,
          orgSignup: false,
        };
        res.forEach((item) => {
          if (item.key === 'pollPrompt') {
            data.pollPrompt = item.value;
          } else if (item.key === 'triviaPrompt') {
            data.triviaPrompt = item.value;
          } else if (item.key === 'signup') {
            const value = JSON.parse(item.value);
            data.userSignup = value.userSignup;
            data.orgSignup = value.orgSignup;
          }
        });
        return { status: true, ...data };
      })
      .catch((error) => {
        return { status: false, value: '{}' };
      });
  }
});
