export default defineEventHandler(async (event) => {
  const method = event.method;
  if (method == 'POST') {
    const formData = await readFormData(event);
    const setting = formData.get('setting') as string;
    if (!setting) {
      return { status: false, message: 'Setting is required' };
    }

    return await prisma.settings
      .upsert({
        where: { key: 'signup' },
        update: {
          value: setting,
        },
        create: {
          key: 'signup',
          value: setting,
        },
      })
      .then(() => {
        return { status: true, message: 'Settings updated successfully' };
      })
      .catch((error) => {
        console.error('Error updating settings:', error);
        return { status: false, message: 'Failed to update settings' };
      });
  }
});
