export default defineEventHandler(async (event) => {
  const method = event.method;
  const query = getQuery(event);
  const page = Number(query.page) || 1;
  const limit = Number(query.limit) || 10;
  const search = query.search || '';
  const status = query.status || 'All';
  const skip = (page - 1) * limit;
  const take = limit;

  const where = {
    type: 'user' as const,
    AND: [
      { OR: [{ approved: null }, { approved: true }, { approved: false }] },
      {
        OR: [{ firstName: { contains: String(search) } }, { lastName: { contains: String(search) } }, { email: { contains: String(search) } }, { phone: { contains: String(search) } }],
      },
    ],
  };
  if (status == 'Approved') {
    where.AND[0].OR = [{ approved: true }];
  } else if (status == 'Rejected') {
    where.AND[0].OR = [{ approved: false }];
  } else if (status == 'Pending') {
    where.AND[0].OR = [{ approved: null }];
  }

  if (method == 'GET') {
    return prisma.user
      .findMany({
        where,
        select: {
          id: true,
          uid: true,
          photo: true,
          email: true,
          phone: true,
          firstName: true,
          lastName: true,
          approved: true,
          createdAt: true,
        },
        orderBy: {
          createdAt: 'desc',
        },
        skip: skip,
        take: take,
      })
      .then(async (data) => {
        const totalCount = await prisma.user.count({
          where,
        });
        return {
          data,
          total: totalCount,
          pages: Math.ceil(totalCount / limit),
        };
      });
  }
});
