import { defineEventHandler } from 'h3';

export default defineEventHandler(async (event) => {
  return await prisma.settings
    .findFirst({
      where: { key: 'signup' },
      select: { value: true },
    })
    .then((ret: any) => {
      if (!ret || !ret.value) return { user: false, org: false };
      const value = JSON.parse(ret.value);
      if (value.userSignup === undefined || value.orgSignup === undefined) return { user: false, org: false };
      return { user: value.userSignup, org: value.orgSignup };
    })
    .catch(() => ({ user: false, org: false }));
});
