import { s3Upload } from '~~/server/utils/s3Actions.post';
import { supabaseAdmin } from '~~/server/utils/supabase';

export default defineEventHandler(async (event) => {
  const form = await readFormData(event);
  const user = JSON.parse(form.get('user') as string);
  const supabase = supabaseAdmin();
  const canSignup = await prisma.settings
    .findFirst({
      where: { key: 'signup' },
      select: { value: true },
    })
    .then((ret: any) => {
      if (!ret || !ret.value) return false;
      const value = JSON.parse(ret.value);
      if (value.orgSignup === undefined) return false;
      return value.orgSignup;
    })
    .catch(() => false);
  if (!canSignup) return { status: false, message: 'Sign Ups are disabled now.' };

  const userExists = await prisma.user.findFirst({
    where: {
      OR: [{ email: user.email }, { phone: user.phone, isd: user.isd }],
    },
  });

  if (userExists) {
    if (userExists.email == user.email) return { status: false, message: 'Email already registered' };
    if (userExists.phone == user.phone && userExists.isd == user.isd && user.phone != '') return { status: false, message: 'Phone Number already registered', location: 'db' };
  }

  user.constDob = user.constDob ? new Date(user.constDob) : null;
  const photo = form.get('photo') as unknown as File;

  let photoUrl: string | undefined;
  if (photo) {
    const folder = user.orgName
      .replace(/[^a-zA-Z0-9]/g, '')
      .replace(/\s/g, '')
      .toLowerCase();
    await s3Upload(photo, folder).then((ret: any) => {
      if (ret.status && ret.url) photoUrl = ret.url;
    });
  }

  const supUser = {
    email: user.email,
    password: user.password,
    email_confirm: true,
    phone: '',
    user_metadata: {
      role: 'organizer',
      name: user.orgName,
      photo: photoUrl,
    },
  };
  return await supabase.auth.admin
    .createUser(supUser)
    .then(async (supdata) => {
      if (supdata.error) {
        let errMsg = '';
        switch (supdata.error.code) {
          case 'phone_exists':
            errMsg = 'Phone Number already registered';
            break;
          case 'email_exists':
            errMsg = 'Email already registered';
            break;
          default:
            errMsg = 'Error creating user';
        }
        if (photoUrl) await s3Delete(photoUrl);
        return { status: false, message: errMsg, supdata };
      }
      const UID = supdata.data.user.id;
      try {
        return await prisma.user
          .create({
            data: {
              uid: UID,
              type: 'organizer',
              photo: photoUrl,
              email: user.email,
              username: user.username,
              bio: user.bio,
              isd: user.isd,
              phone: user.phone,
              address: user.address,
              city: user.city,
              state: user.state,
              zip: user.zip,
              orgName: user.orgName,
              themeColor: user.themeColor || '',
              contact: {
                create: {
                  name: user.contactName || '',
                  email: user.contactEmail || '',
                },
              },
              bank: {
                create: {
                  name: '',
                  account: '',
                  routing: '',
                },
              },
              liveroom: {
                create: {
                  bodySize: 16,
                  headerSize: 16,
                },
              },
            },
          })
          .then(async (userInfo) => {
            return {
              status: true,
              role: 'organizer',
              name: user.orgName,
              photo: user.photo,
            };
          })
          .catch(async (error) => {
            if (photoUrl) await s3Delete(photoUrl);
            await supabase.auth.admin.deleteUser(UID);
            let errMsg = '';
            if (error.meta?.target && error.meta?.target.includes('username')) {
              errMsg = 'Username already registered';
            } else if (error.meta?.target && error.meta?.target.includes('email')) {
              errMsg = 'Email already registered';
            } else {
              errMsg = 'Error creating user';
            }
            return { status: false, message: errMsg, error: error };
          });
      } catch (error) {
        if (photoUrl) await s3Delete(photoUrl);
        await supabase.auth.admin.deleteUser(UID);
        return { status: false, message: error.message, error: error };
      }
    })
    .catch(async (error) => {
      if (photoUrl) await s3Delete(photoUrl);
      return { status: false, message: error.message, error: error };
    });
});
