import { defineEventHandler, readBody } from 'h3';

import { supabaseAdmin } from '~~/server/utils/supabase';
export default defineEventHandler(async (event) => {
  const supabase = supabaseAdmin();
  const body = await readBody(event);
  const user = body.user;
  const canSignup = await prisma.settings
    .findFirst({ where: { key: 'signup' }, select: { value: true } })
    .then((ret: any) => {
      if (!ret || !ret.value) return false;
      const value = JSON.parse(ret.value);
      if (value.userSignup === undefined) return false;
      return value.userSignup;
    })
    .catch(() => false);
  if (!canSignup) return { status: false, message: 'Sign Ups are disabled now.' };

  if (!user.firstName || !user.lastName || !user.email || !user.password) {
    if (!user.firstName) return { status: false, message: 'First name is required' };
    if (!user.lastName) return { status: false, message: 'Last name is required' };
    if (!user.password) return { status: false, message: 'Password is required' };
    if (!user.email) return { status: false, message: 'Email is required' };
  }

  const where = { email: user.email };

  const existingUser = await prisma.user.findUnique({
    where,
    select: { uid: true, email: true, phone: true, isd: true },
  });
  if (existingUser) {
    return { status: false, message: 'Email already registered' };
  }

  const supUser = {
    email: '',
    password: user.password || '',
    email_confirm: true,
    user_metadata: {
      role: 'user',
      name: `${user.firstName} ${user.lastName}`,
      photo: '',
    },
  };
  supUser.email = user.email;

  return await supabase.auth.admin
    .createUser(supUser)
    .then(async (supdata: any) => {
      if (supdata.error || !supdata.data.user) {
        switch (supdata.error.code) {
          case 'phone_exists':
            return { status: false, message: 'Phone number already exists', locator: 'supabase', supdata };
          case 'email_exists':
            return { status: false, message: 'Email already registered.', locator: 'supabase', supdata };
          case 'invalid_phone_number':
            return { status: false, message: 'Invalid phone number', locator: 'supabase', supdata };
          case 'email_address_invalid':
            return { status: false, message: 'Invalid email address', locator: 'supabase', supdata };
          case 'user_already_exists':
            return { status: false, message: 'User already registered.', locator: 'supabase', supdata };
          default:
            return { status: false, message: 'Error creating user', locator: 'supabase', supdata };
        }
      }
      const UID = supdata.data.user.id;
      return await prisma.user
        .create({
          data: {
            uid: UID,
            type: 'user',
            firstName: user.firstName,
            lastName: user.lastName,
            email: user.email || null,
            themeColor: user.themeColor || '',
          },
        })
        .then(async (userInfo) => {
          if (!userInfo) return { status: false, message: 'Error creating user', locator: 'prisma' };
          return { status: true, user: UID };
        })
        .catch(async (error) => {
          console.log(error);
          await supabase.auth.admin.deleteUser(UID);
          await deleteUser(UID);
          switch (error.code) {
            case 'P2002':
              return { status: false, message: 'User already registered.', locator: 'prisma catch', error };
            default:
              return { status: false, message: 'Error creating user', locator: 'prisma catch', error };
          }
        });
    })
    .catch(async (error) => {
      return { status: false, message: 'Error creating user', locator: 'supabase catch', error };
    });
});

const deleteUser = async (uid: string) => {
  await prisma.user
    .delete({ where: { uid } })
    .then(() => {
      return true;
    })
    .catch((error) => {
      return false;
    });
};
