import { defineEventHandler, getRouterParam } from 'h3';

export default defineEventHandler(async (event) => {
  const PROJECT_ID = Number(getRouterParam(event, 'id'));
  if (!PROJECT_ID) return { status: false, message: 'Authentication failed' };
  const project = await prisma.project.findUnique({ where: { id: PROJECT_ID } });
  if (!project) return { status: false, message: 'Project not found' };
  return await prisma.liveroom
    .findFirst({
      where: {
        userId: project.userId,
      },
      select: {
        fanPhBg: true,
        fanPhColor: true,
        fanPhLogo: true,
        fanPhTxt: true,
        fanPhDisplay: {
          select: {
            width: true,
            height: true,
          },
        },
        user: {
          select: {
            photo: true,
          },
        },
      },
    })
    .then((data) => {
      return data;
    })
    .catch((err) => {
      return { status: false, message: 'Error fetching design' };
    });
});
