import { serverSupabaseClient } from "#supabase/server";
import { sendRedirect } from "h3";

export default defineEventHandler(async (event) => {
  const supabase = await serverSupabaseClient(event);

  return await supabase.auth
    .signOut()
    .then(() => {
      return { status: true };
    })
    .catch((error) => {
      return { status: false, message: error.message };
    });
});
