import { defineEventHandler, getQuery } from 'h3';

type getRequest = {
  page: number;
  limit?: number;
};

export default defineEventHandler(async (event) => {
  const method = event.method;

  const query: getRequest = getQuery(event);
  if (method == 'GET') return await getOrganization(query);
});

async function getOrganization(query: getRequest) {
  try {
    const page = query.page || 1;
    const limit = Number(query.limit) || 10;
    const skip = Number((page - 1) * limit);
    try {
      const organizations = await prisma.user.findMany({
        where: {
          type: 'organizer',
        },
        select: {
          id: true,
          photo: true,
          orgName: true,
          city: true,
          state: true,
          raised: true,
          _count: {
            select: {
              followers: true,
              projects: true,
            },
          },
        },
        skip: skip,
        take: limit,
      });

      const modifiedOrganizations = organizations.map((org) => ({
        ...org,
        followers: org._count.followers,
        projects: org._count.projects,
        _count: undefined,
      }));

      const totalCount = await prisma.user.count({
        where: {
          type: 'organizer',
        },
      });
      return {
        organizations: modifiedOrganizations,
        totalCount,
        page,
        totalPages: Math.ceil(totalCount / limit),
      };
    } catch (err: any) {
      return {
        message: 'Error fetching projects',
        error: err.message,
      };
    }
  } catch (err: any) {
    return {
      message: 'Error fetching project',
      error: err.message,
    };
  }
}
