import type {getRequest} from '~~/server/type';

export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);
  const method = event.method;
  if (method == 'GET') {
    const query: getRequest = getQuery(event);
    return await getEvents(query, USER_ID);
  }
});

async function getEvents(query: getRequest, USER_ID: number) {
  const page = query.page || 1;
  const limit = query.limit || 10;
  const skip = (page - 1) * limit;
  try {
    const users = await prisma.user.findMany({
      where: {
        OR: [
          {answers: {some: {project: {userId: USER_ID}}}},
          {drawingEnter: {some: {project: {userId: USER_ID}}}},
          {gameEnters: {some: {project: {userId: USER_ID}}}},
          {fanPhoto: {some: {project: {userId: USER_ID}}}},
        ],
      },
      select: {
        id: true,
        firstName: true,
        lastName: true,
        email: true,
        _count: {
          select: {
            answers: {where: {project: {userId: USER_ID}}},
            drawingEnter: {where: {project: {userId: USER_ID}}},
            gameEnters: {where: {project: {userId: USER_ID}}},
            fanPhoto: {where: {project: {userId: USER_ID}}},
            redeemed: {where: {coupon: {userId: USER_ID}}},
          },
        },
      },
    });
    let totalInt = 0;
    const activities = {
      contest: 0,
      drawing: 0,
      game: 0,
      fanphoto: 0,
    };
    users.forEach(user => {
      user['name'] = `${user.firstName} ${user.lastName}`;
      user['interactions'] =
        (user._count.answers || 0) +
        (user._count.drawingEnter || 0) +
        (user._count.gameEnters || 0) +
        (user._count.fanPhoto || 0);
      totalInt += user['interactions'];
      user['coupons'] = user._count.redeemed || 0;
      user['topInteraction'] = '';
      if (
        (user._count.answers || 0) >= (user._count.drawingEnter || 0) &&
        (user._count.answers || 0) >= (user._count.gameEnters || 0) &&
        (user._count.answers || 0) >= (user._count.fanPhoto || 0)
      ) {
        user['topInteraction'] = 'Contest';
      } else if (
        (user._count.drawingEnter || 0) >= (user._count.answers || 0) &&
        (user._count.drawingEnter || 0) >= (user._count.gameEnters || 0) &&
        (user._count.drawingEnter || 0) >= (user._count.fanPhoto || 0)
      ) {
        user['topInteraction'] = 'Drawing';
      } else if (
        (user._count.gameEnters || 0) >= (user._count.answers || 0) &&
        (user._count.gameEnters || 0) >= (user._count.drawingEnter || 0) &&
        (user._count.gameEnters || 0) >= (user._count.fanPhoto || 0)
      ) {
        user['topInteraction'] = 'Game';
      } else if (
        (user._count.fanPhoto || 0) >= (user._count.answers || 0) &&
        (user._count.fanPhoto || 0) >= (user._count.drawingEnter || 0) &&
        (user._count.fanPhoto || 0) >= (user._count.gameEnters || 0)
      ) {
        user['topInteraction'] = 'Fan Photo';
      }
      user['contest'] = user._count.answers || 0;
      user['drawing'] = user._count.drawingEnter || 0;
      user['game'] = user._count.gameEnters || 0;
      user['fanphoto'] = user._count.fanPhoto || 0;
      delete user._count;
      delete user.firstName;
      delete user.lastName;
      activities.contest += user['contest'];
      activities.drawing += user['drawing'];
      activities.game += user['game'];
      activities.fanphoto += user['fanphoto'];
    });

    const avgInt = totalInt / users.length || 0;

    return {
      user: users.length,
      interaction: totalInt,
      users: users,
      avgInt: Math.round(avgInt),
      topActivity: Object.keys(activities).reduce((a, b) => (activities[a] > activities[b] ? a : b)),
      page,
    };
  } catch (err: any) {
    return {
      message: 'Error fetching coupons',
      error: err.message,
    };
  }
}
