import {createClient} from '@supabase/supabase-js';
import {supabaseAdmin} from '~~/server/utils/supabase';

export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);
  const userEmail = event.context.user.email;

  const body = await readBody(event);
  const {oldPassword, newPassword} = body ?? {};

  if (!oldPassword || !newPassword) {
    return apiResponse({status: false, message: 'All fields are required'});
  }

  if (newPassword.length < 6) {
    return apiResponse({status: false, message: 'Password must be at least 6 characters'});
  }

  const env = useRuntimeConfig();

  // Verify old password by attempting sign-in
  const tempClient = createClient(env.public.SUPABASE_URL!, env.public.SUPABASE_KEY!);
  const {error: signInError} = await tempClient.auth.signInWithPassword({
    email: userEmail,
    password: oldPassword,
  });

  if (signInError) {
    return apiResponse({status: false, message: 'Current password is incorrect'});
  }

  // Get user's Supabase UID
  const user = await prisma.user.findUnique({
    where: {id: USER_ID},
    select: {uid: true},
  });

  if (!user) {
    return apiResponse({status: false, message: 'User not found'});
  }

  try {
    const supabase = supabaseAdmin();
    const {error} = await supabase.auth.admin.updateUserById(user.uid, {
      password: newPassword,
    });

    if (error) {
      return apiResponse({status: false, message: error.message});
    }

    return apiResponse({message: 'Password changed successfully'});
  } catch (err: any) {
    return apiResponse({status: false, message: err.message || 'Failed to change password'});
  }
});
