export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);
  const {projectId, drawing} = await readBody(event);

  if (drawing && drawing.length > 0) {
    return await prisma.drawingEnter
      .updateMany({
        where: {
          id: {in: drawing},
          project: {
            userId: USER_ID,
          },
        },
        data: {winner: true},
      })
      .then(() => {
        return {status: true};
      })
      .catch(error => {
        return {status: false, message: error.message};
      });
  }

  if (!projectId) {
    return {status: false, message: 'Project ID is required'};
  }

  return await prisma.drawingEnter
    .findMany({
      where: {projectId: Number(projectId)},
    })
    .then(async res => {
      const total = res.length;
      const index = Math.floor(Math.random() * total);
      const winner = res[index];
      await prisma.drawingEnter.update({
        where: {id: winner.id},
        data: {winner: true},
      });

      return {status: true, data: res};
    })
    .catch(error => {
      return {status: false, message: error.message};
    });
});
