import { defineEventHandler, readBody, createError } from 'h3';

export default defineEventHandler(async (event) => {
  const userId = event.context.user?.id;
  const { sponsors } = await readBody<{ sponsors?: number[] }>(event);

  if (!userId) {
    throw createError({ statusCode: 401, statusMessage: 'Unauthorized' });
    return [];
  }

  if (!Array.isArray(sponsors) || sponsors.length === 0) {
    return [];
  }

  return prisma.coupon.findMany({
    where: {
      userId,
      sponsorId: { in: sponsors },
    },
    select: {
      id: true,
      name: true,
    },
  });
});
