import type {ApiResponse, getRequest} from '~~/server/type';

export default defineEventHandler(async event => {
  const USER = event.context.user;
  const query: getRequest = getQuery(event);
  return await getCoupons(query, USER);
});

async function getCoupons(query: getRequest, USER: {id: number; photo: string}) {
  const page = query.page || 1;
  const limit = query.limit || 10;
  const skip = (page - 1) * limit;
  try {
    const coupons = await prisma.coupon.findMany({
      where: {
        userId: USER.id,
      },
      select: {
        id: true,
        logo: true,
        name: true,
        code: true,
        description: true,
        expiry: true,
      },
      skip: skip,
      take: limit,
    });
    coupons.map(coupon => {
      coupon.logo = coupon.logo ? coupon.logo : USER.photo;
    });

    const items = await prisma.coupon.count({where: {userId: USER.id}});

    return apiResponse({
      result: coupons,
      meta: {
        items,
        page,
        pages: Math.ceil(items / limit),
      },
    });
  } catch (err) {
    return apiResponse({
      status: false,
      message: err instanceof Error ? err.message : 'Error fetching coupons',
      error: err,
    });
  }
}
