export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);
  const form = await readFormData(event);
  return await addCoupon(form, USER_ID);
});

async function addCoupon(form: FormData, USER_ID: number) {
  const coupon = JSON.parse(form.get('project') as string);
  const logo = form.get('logo') as File | null;
  const photo = form.get('photo') as File | null;
  try {
    if (logo) {
      await s3Upload(logo, USER_ID).then(({status, url}) => {
        if (status && url) coupon.logo = url;
      });
    }
    if (photo) {
      await s3Upload(photo, USER_ID).then(({status, url}) => {
        if (status && url) coupon.photo = url;
      });
    }
    const result = await prisma.coupon.create({
      data: {
        logo: coupon.logo,
        name: coupon.name,
        photo: coupon.photo,
        description: coupon.description,
        urlText: coupon.urlText,
        url: coupon.url,
        sponsor: {connect: {id: Number(coupon.sponsor)}},
        code: coupon.code,
        expiry: coupon.expiry ? new Date(coupon.expiry) : null,
        user: {connect: {id: USER_ID}},
      },
    });

    if (result) return apiResponse({result: result.id});

    throw new Error('Error adding Coupon');
  } catch (error) {
    if (coupon.logo) await s3Delete(coupon.logo).catch(() => null);
    if (coupon.photo) await s3Delete(coupon.photo).catch(() => null);
    return apiResponse({status: false, message: 'Error adding Coupon.', error});
  }
}
