export default defineEventHandler(async event => {
  const USER = event.context.user;
  const userInfo = await prisma.user.findUnique({
    where: {id: USER.id},
    select: {
      orgName: true,
      bio: true,
      address: true,
      city: true,
      state: true,
      _count: {
        select: {followers: true},
      },
      liveroom: {
        select: {
          active: true,
        },
      },
    },
  });
  const queue = await prisma.project.count({
    where: {
      userId: USER.id,
      status: 'queue',
    },
  });
  const coupon = await prisma.coupon.count({
    where: {
      userId: USER.id,
    },
  });

  const sponsors = await prisma.sponsor.count({
    where: {
      userId: USER.id,
    },
  });
  const result = {
    photo: USER.photo,
    name: userInfo?.orgName,
    address: userInfo?.city + ', ' + userInfo?.state,
    followers: userInfo?._count?.followers,
    bio: userInfo?.bio,
    queue,
    coupon,
    sponsors,
    liveroom: userInfo?.liveroom?.active ?? false,
  };
  return apiResponse({result});
});
