export default defineEventHandler(async event => {
  const userId = Number(event.context.user.id);
  const body = await readBody(event);
  const {primary, secondary, darkPrimary, darkSecondary} = body;
  try {
    const themeUpdate = await prisma.user.update({
      where: {id: userId},
      data: {theme: {primary, secondary, darkPrimary, darkSecondary}},
    });
    if (themeUpdate) return apiResponse({result: true});
    throw new Error('Something went wrong please try again.');
  } catch (error) {
    return apiResponse({
      result: false,
      message: error instanceof Error ? error.message : 'Something went wrong please try again.',
    });
  }
});
