export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.userId);
  if (!USER_ID) return apiResponse({status: false, message: 'Invalid request'});

  const LiveRoom = await prisma.liveroom.findFirst({
    where: {userId: USER_ID},
    select: {
      id: true,
      songGameQr: true,
    },
  });

  if (!LiveRoom) return apiResponse({status: false, message: 'Live room not found'});

  const form = await readFormData(event);
  const design = JSON.parse(form.get('design') as string);
  const background = form.get('background') as File | null;
  const logo = form.get('logo') as File | null;
  const oldDesign = LiveRoom.songGameQr as Record<string, string> | null;

  try {
    if (design.logo === '' && oldDesign?.logo) await s3Delete(oldDesign.logo);
    if (design.background === '' && oldDesign?.background) await s3Delete(oldDesign.background);

    if (background) {
      const ret = await s3Upload(background, USER_ID);
      if (ret.status && ret.url) {
        design.background = ret.url;
        if (oldDesign?.background) await s3Delete(oldDesign.background);
      }
    }

    if (logo) {
      const ret = await s3Upload(logo, USER_ID);
      if (ret.status && ret.url) {
        design.logo = ret.url;
        if (oldDesign?.logo) await s3Delete(oldDesign.logo);
      }
    }

    await prisma.liveroom.update({
      where: {id: LiveRoom.id},
      data: {
        songGameQr: {
          background: design.background,
          logo: design.logo,
          hedLeft: design.hedLeft,
          hedRight: design.hedRight,
          hedBorder: design.hedBorder,
          title: design.title,
          subTitle: design.subTitle,
          boxBg: design.boxBg,
          boxBorder: design.boxBorder,
          text: design.text,
          percent: design.percent,
        },
      },
    });

    return apiResponse({message: 'Design saved'});
  } catch (error) {
    return apiResponse({status: false, message: 'Failed to save design', error});
  }
});
