export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.userId);

  if (!USER_ID) return apiResponse({status: false, message: 'Invalid request'});
  const LiveRoom = await prisma.liveroom.findFirst({
    where: {userId: USER_ID},
    select: {
      bodyImg: true,
      popupBg: true,
      popupColor: true,
    },
  });

  if (!LiveRoom) return apiResponse({status: false, message: 'Live room not found'});

  return apiResponse({status: true, result: LiveRoom});
});
