export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.userId);

  if (!USER_ID) return {status: false, message: 'Invalid request'};
  const LiveRoom = await prisma.liveroom.findFirst({
    where: {userId: USER_ID},
  });

  if (!LiveRoom) return {status: false, message: 'Live room not found'};

  const form = await readFormData(event);
  const bodyImg = form.get('bodyImg') as File | null;
  const popupColor = form.get('popupColor') as string;
  const popupBg = form.get('popupBg') as string;

  return await addDesign(LiveRoom, bodyImg, popupColor, popupBg, USER_ID);
});

async function addDesign(LiveRoom: any, newBodyImg: File | null, popupColor: string, popupBg: string, USER_ID: number) {
  let bodyImg = LiveRoom.bodyImg;
  try {
    if (newBodyImg) {
      await s3Upload(newBodyImg, USER_ID).then(async ({status, url}) => {
        if (status && url) {
          bodyImg = url;
          if (LiveRoom.bodyImg && LiveRoom.bodyImg != '') await s3Delete(LiveRoom.bodyImg);
        }
      });
    }
    const design = await prisma.liveroom.update({
      where: {id: LiveRoom.id},
      data: {
        bodyImg,
        popupBg,
        popupColor,
      },
    });
    if (design) return apiResponse({result: {id: design.id, bodyImg: design.bodyImg}});
    throw new Error('Failed to update design');
  } catch (error) {
    return apiResponse({status: false, message: '', error});
  }
}
