export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);
  const method = event.method;
  if (method == 'GET') {
    return await prisma.display.findMany({
      where: {
        user: {
          id: USER_ID,
        },
      },
    });
  } else if (method == 'POST') {
    const form = await readFormData(event);
    return await addDisplay(form, USER_ID);
  }
});

async function addDisplay(form: FormData, USER_ID: number) {
  const display = JSON.parse(form.get('display') as string);
  const photo = form.get('photo') as File | null;

  if (display.name && display.width && display.height) {
    let logo = '';
    if (photo) {
      await s3Upload(photo, USER_ID).then((ret: any) => {
        if (ret.status && ret.url) logo = ret.url;
      });
    }
    return await prisma.display
      .create({
        data: {
          logo: logo,
          name: display.name,
          width: display.width,
          height: display.height,
          user: {connect: {id: USER_ID}},
        },
      })
      .then(data => {
        return data ? {status: true} : {status: false};
      })
      .catch(async err => {
        return {
          status: false,
          errors: err,
          message: 'Error adding display',
        };
      });
  } else {
    let errors: string = '';
    return {
      message: errors,
    };
  }
}
