import {s3Upload} from '~~/server/utils/s3Actions.post';

export default defineEventHandler(async event => {
  const USER = event.context.user;
  const USER_ID = Number(USER.id);
  if (!USER.permissions.fanphoto)
    return apiResponse({status: false, message: 'You do not have permission to create fanphotos.'});

  const form = await readFormData(event);
  return await addFanPhoto(form, USER_ID);
});

async function addFanPhoto(form: FormData, USER_ID: number) {
  const project = JSON.parse(form.get('project') as string);
  const photo = form.get('photo') as File | null;

  try {
    if (photo) {
      await s3Upload(photo, USER_ID).then(({status, url}) => {
        if (status && url) project.photo = url;
      });
    }

    const retult = await prisma.project.create({
      data: {
        photos: [],
        photo: project.photo,
        name: project.name,
        category: 'fanphoto',
        status: 'queue',
        target: project.target,
        type: 'fanphoto',
        teamTag: project.teamTag || null,
        eventDate: project.eventDate ? new Date(project.eventDate) : null,
        eventName: project.eventName || null,
        user: {connect: {id: USER_ID}},
        approved: true,
      },
    });
    if (retult) return apiResponse({result: retult.id});
    throw new Error('');
  } catch (error) {
    if (project.photo) await s3Delete(project.photo).catch(() => null);
    return apiResponse({status: false, message: 'Error adding Fanphoto.', error});
  }
}
