import type {ApiResponse} from '#server/type';
import {s3Delete, s3Upload} from '~~/server/utils/s3Actions.post';

export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);
  const form = await readFormData(event);
  return await addProject(form, USER_ID);
});

async function addProject(form: FormData, USER_ID: number) {
  const project = JSON.parse(form.get('project') as string);
  const photo = form.get('photo') as File;

  try {
    if (photo) {
      await s3Upload(photo, USER_ID).then(({status, url}) => {
        if (status && url) project.photo = url;
      });
    }

    const data = await prisma.project.create({
      data: {
        category: 'fundraiser',
        photos: [],
        photo: project.photo,
        name: project.name,
        teamTag: JSON.stringify(project.teamTag),
        sponsors: {
          connect: project.sponsors.map((sponsor: {id: number}) => ({
            id: Number(sponsor.id),
          })),
        },
        coupons: {
          connect: project.coupons.map((coupon: {id: number}) => ({
            id: Number(coupon.id),
          })),
        },
        type: 'fundraiser',
        status: 'queue',
        user: {connect: {id: USER_ID}},
        description: project.description,
        approved: true,
      },
    });
    if (data) return apiResponse({result: data.id});
    throw new Error('');
  } catch (error) {
    if (project.photo) await s3Delete(project.photo).catch(() => null);
    return apiResponse({status: false, message: 'Error adding Fundraiser Project.', error});
  }
}
