export default defineEventHandler(async event => {
  const USER = event.context.user;
  const USER_ID = Number(USER.id);
  if (!USER.permissions.game)
    return apiResponse({status: false, message: 'You do not have permission to create game.'});

  const form = await readFormData(event);

  const project = JSON.parse(form.get('project') as string);
  const photo = form.get('photo') as File | null;

  project.expiry = project.expiry ? new Date(project.expiry) : null;

  project.photos = [];

  try {
    if (photo) {
      await s3Upload(photo, USER_ID).then(({status, url}) => {
        if (status && url) project.photo = url;
      });
    }
    const result = await prisma.project.create({
      data: {
        category: 'game',
        name: project.name,
        photos: [],
        photo: project.photo,
        distribution: project.distribution,
        liveTitle: project.liveTitle || '',
        qrTitle: project.qrTitle || '',
        description: project.description ?? '',
        teamTag: project.teamTag || null,
        eventDate: project.eventDate ? new Date(project.eventDate) : null,
        eventName: project.eventName || null,
        delayed: project.delayed,
        notify: project.notify,
        sponsors: {
          connect: project.sponsors.map((sponsor: object) => ({
            id: Number(sponsor.id),
          })),
        },
        coupons: {
          connect: project.coupons.map((coupon: object) => ({
            id: Number(coupon.id),
          })),
        },
        status: 'queue',
        userId: USER_ID,
        type: project.type || '',
        expiry: project.expiry,
        approved: true,
      },
    });

    if (!result) throw new Error('Error adding project');

    const newData = {
      photo: '',
      title: '',
      desc: '',
      target: 0,
      video: '',
      projectId: result.id,
      userId: USER_ID,
    };
    if (project.type === 'target') {
      newData.target = project.game.target;
      newData.title = project.game.title;
      newData.desc = project.game.desc;
    }
    if (project.type === 'rateit' && project.games) {
      project.games.forEach(async (game: any) => {
        newData.target = game.target;
        newData.title = game.title;
        newData.desc = game.desc;
        newData.video = game.video;
      });
    }
    await prisma.game.create({
      data: newData,
    });

    return apiResponse({result: result.id});
  } catch (error) {
    if (project.photo) await s3Delete(project.photo).catch(() => null);
    return apiResponse({status: false, message: 'Error adding Game.', error});
  }
});
