import type {getRequest} from '~~/server/type';

export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);
  const query: getRequest = getQuery(event);
  return await getProjects(query, USER_ID);
});

async function getProjects(query: getRequest, USER_ID: number) {
  const user = await prisma.user.findUnique({where: {id: USER_ID}, select: {approved: true}});
  if (!user) throw createError({statusCode: 404, statusMessage: 'User not found'});

  return await prisma.project
    .findMany({
      where: {
        userId: USER_ID,
      },
      select: {
        id: true,
        photos: true,
        name: true,
      },
      orderBy: {
        id: 'desc',
      },
      take: 4,
    })
    .then(async result => {
      return apiResponse({result});
    })
    .catch(err => {
      return apiResponse({
        status: false,
        message: err.message || 'Error fetching projects',
        error: err,
      });
    });
}
