import type {getRequest} from '~~/server/type';

export default defineEventHandler(async event => {
  const USER = await event.context.user;
  const query: getRequest = getQuery(event);
  return await getProjects(query, USER);
});

async function getProjects(query: getRequest, USER: {id: number; photo: string}) {
  const page = query.page || 1;
  const limit = query.limit || 50;
  const skip = (page - 1) * limit;
  try {
    const projects = await prisma.project.findMany({
      where: {
        userId: USER.id,
      },
      select: {
        id: true,
        photo: true,
        name: true,
        category: true,
        type: true,
        status: true,
      },
      orderBy: {
        id: 'desc',
      },
      skip: skip,
      take: limit,
    });
    const totalCount = await prisma.project.count({where: {userId: USER.id}});
    projects.forEach(project => {
      if (!project.photo) project.photo = USER.photo || '';
    });
    return apiResponse({result: projects, meta: {items: totalCount, page, pages: Math.ceil(totalCount / limit)}});
  } catch (err) {
    return apiResponse({
      status: false,
      message: err instanceof Error ? err.message : 'Error fetching projects',
      error: err instanceof Error ? err : new Error(String(err)),
    });
  }
}
