export default defineEventHandler(async event => {
  const USER = event.context.user;
  return await getRoster(USER.id);
});

async function getRoster(userId: number) {
  try {
    const rosters = await prisma.rosterTeam.findMany({
      where: {userId},
      select: {
        id: true,
        side: true,
        logo: true,
        players: {
          orderBy: {order: 'asc'},
          select: {
            id: true,
            number: true,
            name: true,
            position: true,
            class: true,
            height: true,
            hometown: true,
            bio: true,
            photo: true,
            order: true,
          },
        },
      },
      orderBy: {side: 'asc'},
    });

    const home = rosters.find(roster => roster.side === 'home');
    const away = rosters.find(roster => roster.side === 'away');

    return apiResponse({
      result: {home: home?.players || [], away: away?.players || []},
    });
  } catch (err) {
    return apiResponse({status: false, message: 'Error fetching roster.', error: err});
  }
}
