export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);

  const form = await readFormData(event);
  const file = form.get('file') as File | null;
  const oldKey = form.get('oldKey') as string | null;

  if (!file) return {status: false, message: 'No file provided'};

  // Debug file information
  console.log(` Logo upload - File info:`, {
    name: file.name,
    type: file.type,
    size: file.size,
    lastModified: file.lastModified,
  });

  // Validate file size
  if (file.size < 100) {
    console.error(` File too small: ${file.size} bytes`);
    return {status: false, message: 'File too small or corrupted'};
  }

  // Validate file type
  if (!file.type.startsWith('image/')) {
    console.error(` Invalid file type: ${file.type}`);
    return {status: false, message: 'Invalid file type'};
  }

  // Delete old logo if oldKey is provided
  if (oldKey && oldKey.trim() !== '') {
    try {
      console.log(` Attempting to delete old logo: ${oldKey}`);
      console.log(` Full URL would be: https://media.palmy.io/${oldKey}`);
      const deleteResult = await s3Delete(oldKey);
      if (deleteResult.status) {
        console.log(` Successfully deleted old logo: ${oldKey}`);
        console.log(` Delete result:`, deleteResult);
      } else {
        console.warn(` Failed to delete old logo: ${oldKey}`, deleteResult.error);
      }
    } catch (error) {
      console.warn(` Error deleting old logo: ${oldKey}`, error);
      // Continue with upload even if delete fails
    }
  }

  const ret = await s3Upload(file, USER_ID);
  if (ret && (ret as any).status && (ret as any).url) {
    return {status: true, url: (ret as any).url, fullUrl: (ret as any).fullUrl};
  }
  return {status: false, message: 'Upload failed'};
});
