import { H3Event, createError } from "h3";

const config = useRuntimeConfig();

const GOOGLE_API_KEY = config.GOOGLE_API_KEY;
const GOOGLE_CX_ID = config.GOOGLE_CX_ID;

export default defineEventHandler(async (event: H3Event) => {
  const body = await readBody(event);
  const { song } = body;

  try {
    const res = await fetch(
      `https://www.googleapis.com/customsearch/v1?q=${encodeURIComponent(
        song
      )}&searchType=image&imgSize=medium&rights=cc_publicdomain,cc_attribute&key=${GOOGLE_API_KEY}&cx=${GOOGLE_CX_ID}`
    );
    const data: any = await res.json();
    const images: string[] = [];

    data.items.forEach((item: any) => {
      if (item.link && typeof item.link === "string") {
        images.push(item.link);
      }
    });
    return {
      status: true,
      images: images,
    };
  } catch (e) {
    return {
      status: false,
    };
  }
});
