import {defineEventHandler, getQuery} from 'h3';
import type {getRequest} from '~~/server/type';

export default defineEventHandler(async event => {
  const USER = event.context.user;
  const query: getRequest = getQuery(event);
  return await getSponsors(query, USER);
});

async function getSponsors(query: getRequest, USER: {id: number; photo: string}) {
  const page = query.page || 1;
  const limit = query.limit || 10;
  const skip = (page - 1) * limit;
  try {
    const sponsors = await prisma.sponsor.findMany({
      where: {userId: USER.id},
      select: {
        id: true,
        name: true,
        email: true,
        address: true,
        logo: true,
      },
      skip: skip,
      take: limit,
    });

    sponsors.map(sponsor => {
      sponsor.logo = sponsor.logo ? sponsor.logo : USER.photo;
    });

    const items = await prisma.sponsor.count({where: {userId: USER.id}});

    return apiResponse({
      result: sponsors,
      meta: {
        items,
        page,
        pages: Math.ceil(items / limit),
      },
    });
  } catch (err) {
    return apiResponse({
      status: false,
      message: err instanceof Error ? err.message : 'Error fetching sponsors',
      error: err,
    });
  }
}
