export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);
  const form = await readFormData(event);
  return await addSponsor(form, USER_ID);
});

async function addSponsor(form: FormData, USER_ID: number) {
  const sponsor = JSON.parse(form.get('project') as string);
  const logo = form.get('photo') as File | null;

  try {
    if (logo) {
      await s3Upload(logo, USER_ID).then(async ({status, url}) => {
        if (status && url) {
          if (sponsor.logo && sponsor.logo != '') await s3Delete(sponsor.logo);
          sponsor.logo = url;
        }
      });
    }

    const result = await prisma.sponsor.create({
      data: {
        logo: sponsor.logo,
        name: sponsor.name,
        address: sponsor.address,
        contactName: sponsor.contactName,
        isd: sponsor.isd,
        phone: sponsor.phone,
        email: sponsor.email,
        showInRoom: sponsor.showInRoom || false,
        user: {connect: {id: USER_ID}},
        coupons: {create: []},
        projects: {create: []},
      },
    });

    if (result) return apiResponse({result: result.id});

    throw new Error('Error adding sponsor');
  } catch (error) {
    if (sponsor.logo) await s3Delete(sponsor.logo).catch(() => null);
    return apiResponse({status: false, message: 'Error adding sponsor.', error});
  }
}
