import { defineEventHandler, createError } from 'h3';

export default defineEventHandler(async (event) => {
  const userId = event.context.user?.id;

  if (!userId) {
    throw createError({
      statusCode: 401,
      statusMessage: 'Unauthorized',
    });
    return [];
  }

  return prisma.sponsor.findMany({
    where: { userId },
    select: {
      id: true,
      name: true,
    },
  });
});
