import type {getRequest} from '~~/server/type';

export default defineEventHandler(async event => {
  const USER = event.context.user;

  const query: getRequest = getQuery(event);
  return await getTemplates(query, USER);
});

async function getTemplates(query: getRequest, USER: {id: number}) {
  const page = query.page || 1;
  const limit = query.limit || 10;
  const skip = (page - 1) * limit;
  try {
    const result = await prisma.template.findMany({
      where: {
        userId: USER.id,
      },
      select: {
        id: true,
        name: true,
        type: true,
      },
      orderBy: {id: 'desc'},
      skip: skip,
      take: limit,
    });

    return apiResponse({result});
  } catch (err: unknown) {
    return apiResponse({status: false, message: 'Error fetching templates', error: err});
  }
}
