import {ApiResponse} from '~~/server/utils/apiResponse';

export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);

  const form = await readFormData(event);
  return await addTemplate(form, USER_ID);
});

async function addTemplate(form: FormData, USER_ID: number) {
  const name = form.get('name') as string;
  const project = JSON.parse(form.get('project') as string);
  const photo = form.get('photo') as File;
  project.expiry = project.expiry ? new Date(project.expiry) : null;

  try {
    if (photo) {
      await s3Upload(photo, USER_ID).then(({status, url}) => {
        if (status && url) project.photo = url;
      });
    }

    if (project.contests.length > 0) {
      const promises = Object.entries(project.contests).map(async ([key, _contest]) => {
        const contestImage = form.get('contestImage' + key) as unknown as File;

        if (contestImage) {
          await s3Upload(contestImage, USER_ID).then(({status, url}) => {
            if (status && url) project.contests[key].image = url;
          });
        }
      });
      await Promise.all(promises);
    }
    const result = await prisma.template.create({
      data: {
        name: name,
        type: project.type,
        project: JSON.stringify(project),
        userId: USER_ID,
      },
    });

    if (result) {
      return apiResponse({result: result.id});
    }

    throw new Error('Error adding Template');
  } catch (error) {
    if (project.photo) await s3Delete(project.photo).catch(() => null);
    if (project.contests.length > 0) {
      const deletePromises = Object.entries(project.contests).map(async ([, contest]) => {
        if (contest.image) {
          await s3Delete(contest.image).catch(() => null);
        }
      });
      await Promise.all(deletePromises);
    }
    return apiResponse({status: false, message: 'Error adding Template.', error});
  }
}
