import { defineEventHandler, getQuery } from 'h3';

export default defineEventHandler(async (event) => {
  const q = getQuery(event);
  const userId = Number(q.userId);
  if (!userId) return { status: false, message: 'userId required' };

  const settings = await prisma.rosterSettings.findUnique({ where: { userId }, select: { enabled: true, mode: true } });
  if (!settings?.enabled) return { status: false, message: 'Roster not published yet. Check back soon.' };

  const teams = await prisma.rosterTeam.findMany({
    where: { userId },
    select: {
      id: true,
      side: true,
      logo: true,
      players: {
        orderBy: { order: 'asc' },
        select: { id: true, number: true, name: true, position: true, class: true, height: true, hometown: true, bio: true, photo: true },
      },
    },
    orderBy: { side: 'asc' },
  });

  return { status: true, settings, teams };
});
